/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.test.yak.ci;

import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.base.BaseContainer;
import com.xebialabs.deployit.plugin.test.yak.ci.RestartRequiringDeployedYakFile;
import com.xebialabs.deployit.plugin.test.yak.step.StartYakServerStep;
import com.xebialabs.deployit.plugin.test.yak.step.StopYakServerStep;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

@Metadata(root=Metadata.ConfigurationItemRoot.INFRASTRUCTURE)
public class YakServer
extends BaseContainer {
    @Contributor
    public void restartYakServers(Deltas deltas, DeploymentPlanningContext deploymentPlanningContext) {
        for (YakServer yakServer : YakServer.serversRequiringRestart(deltas.getDeltas())) {
            deploymentPlanningContext.addStep((DeploymentStep)new StopYakServerStep(yakServer));
            deploymentPlanningContext.addStep((DeploymentStep)new StartYakServerStep(yakServer));
        }
    }

    private static Set<YakServer> serversRequiringRestart(List<Delta> list) {
        TreeSet<YakServer> treeSet = new TreeSet<YakServer>();
        for (Delta delta : list) {
            if (!(delta.getDeployed() instanceof RestartRequiringDeployedYakFile) || !(delta.getDeployed().getContainer() instanceof YakServer)) continue;
            treeSet.add((YakServer)delta.getDeployed().getContainer());
        }
        return treeSet;
    }
}

