package com.xebialabs.gradle.plugins.thirdpartylicense

import org.gradle.api.artifacts.Configuration


class ThirdPartyLicenseExtension {
  boolean failOnMissingLicense
  def ignoredGroups
  def licenseDatabaseFileOrConfiguration
  def reportHeader

  def setLicenseDatabaseConfiguration(Configuration cfg) {
    licenseDatabaseFileOrConfiguration = cfg
  }

  def setLicenseDatabaseFile(def file) {
    licenseDatabaseFileOrConfiguration = file
  }

  def getLicenseDatabaseFile() {
    if (licenseDatabaseFileOrConfiguration instanceof Configuration) {
      return null
    }
    return licenseDatabaseConfiguration
  }

  def getLicenseDatabaseConfiguration() {
    if (licenseDatabaseFileOrConfiguration instanceof Configuration) {
      return licenseDatabaseConfiguration
    }
    return null
  }
}
