package com.xebialabs.gradle.plugins.thirdpartylicense

import org.gradle.api.Plugin
import org.gradle.api.Project
import org.gradle.api.artifacts.Configuration

import com.xebialabs.gradle.plugins.thirdpartylicense.tasks.LicenseCheckAndDoc

class ThirdPartyLicensePlugin implements Plugin<Project> {
  public static final String PLUGIN_EXTENSION_NAME = "thirdPartyLicense"
  public static final String DEFAULT_CONFIGURATION = "thirdPartyLicenseDatabase"

  ThirdPartyLicenseExtension extension

  @Override
  public void apply(Project project) {
    Configuration cfg = addDefaultConfiguration(project)
    addExtension(project, cfg)
    configureTaskDefaults(project)
  }

  def addExtension(Project project, Configuration cfg) {
    extension = project.extensions.create(PLUGIN_EXTENSION_NAME, ThirdPartyLicenseExtension)
    extension.with {
      failOnMissingLicense = true
      ignoredGroups = []
      licenseDatabaseFileOrConfiguration = cfg
      reportHeader = """This notice contains information about the OSS software used in the XL Deploy
server. XL Deploy contains the following OSS components grouped by license:\n"""
    }
  }

  Configuration addDefaultConfiguration(Project project) {
    Configuration cfg = project.configurations.create(DEFAULT_CONFIGURATION)
    cfg.with {
      visible = false
      transitive = false
      description = 'Default configuration for third party license database artifact.'
    }
    return cfg
  }

  def configureTaskDefaults(Project project) {
    project.tasks.withType(LicenseCheckAndDoc) { LicenseCheckAndDoc task ->
      logger.info("Applying license defaults to task {}", task)
      configureTaskDefaults(task)
    }
  }

  def configureTaskDefaults(LicenseCheckAndDoc task) {
    task.conventionMapping.with {
      failOnMissingLicense = { extension.failOnMissingLicense }
      ignoredGroups = { extension.ignoredGroups }
      reportHeader = { extension.reportHeader }
      licenseDatabaseFileOrConfiguration = { extension.getLicenseDatabaseFileOrConfiguration() }
    }
  }
}
