package com.xebialabs.gradle.plugins

import com.xebialabs.gradle.plugins.thirdpartylicense.tasks.LicenseCheckAndDoc
import com.xebialabs.gradle.plugins.thirdpartylicense.tasks.LicenseReportTask
import org.gradle.api.Project

public class XLDPluginPlugin extends AbstractBundlingPluginPlugin {

  @Override
  String getPluginExtension() {
    return "xldp"
  }

  @Override
  public void apply(Project project) {
    super.apply(project)
    project.apply plugin: "xebialabs.document-generator"
    project.apply plugin: "xebialabs.3rd-party-license"

    configureLicenseTasks(project)
  }

  protected void configureLicenseTasks(Project project) {
    def noticeFile = "${project.buildDir}/reports/license-notice.txt"

    project.tasks.create("licenseReport", LicenseReportTask).configure {
      outputFile = "${project.buildDir}/reports/licenses-guessed.json"
      configuration = project.configurations.getByName("distBundle")
    }

    def licenseCheckTask = project.tasks.create("licenseCheck", LicenseCheckAndDoc).configure {
      outputFile = noticeFile
      configuration = project.configurations.getByName("distBundle")
    }

    // make things fail a bit earlier
    project.tasks.getByName("build").mustRunAfter licenseCheckTask
    project.rootProject.tasks.getByName("prepare").dependsOn << licenseCheckTask

    project.tasks.getByName(XLPluginBundlePlugin.BUNDLING_TASK_NAME).configure {
      dependsOn << licenseCheckTask
      into(".") {
        from noticeFile
      }
    }

    project.dependencies {
      thirdPartyLicenseDatabase 'com.xebialabs.deployit.gradle:license-data'
    }
  }
}
