/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.util;

import groovyx.net.http.HTTPBuilder;
import java.net.ServerSocket;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.nio.charset.Charset;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.apache.http.client.HttpClient;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lai/digital/integration/server/util/HTTPUtil;", "", "()V", "Companion", "integration-server-gradle-plugin"})
public class HTTPUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    @NotNull
    public static final HTTPBuilder buildRequest(@NotNull String url) {
        return Companion.buildRequest(url);
    }

    @JvmStatic
    @NotNull
    public static final HttpRequest.Builder doRequest(@NotNull String url) {
        return Companion.doRequest(url);
    }

    @JvmStatic
    public static final int findFreePort() {
        return Companion.findFreePort();
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u0004H\u0007J\b\u0010\n\u001a\u00020\u000bH\u0007\u00a8\u0006\f"}, d2={"Lai/digital/integration/server/util/HTTPUtil$Companion;", "", "()V", "basicAuth", "", "buildRequest", "Lgroovyx/net/http/HTTPBuilder;", "url", "doRequest", "Ljava/net/http/HttpRequest$Builder;", "findFreePort", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final HTTPBuilder buildRequest(@NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            int timeout = 180000;
            HTTPBuilder http = new HTTPBuilder((Object)url);
            HttpClient httpClient = http.getClient();
            Intrinsics.checkNotNullExpressionValue((Object)httpClient, (String)"http.client");
            httpClient.getParams().setParameter("http.connection.timeout", (Object)timeout);
            HttpClient httpClient2 = http.getClient();
            Intrinsics.checkNotNullExpressionValue((Object)httpClient2, (String)"http.client");
            httpClient2.getParams().setParameter("http.socket.timeout", (Object)timeout);
            http.getAuth().basic("admin", "admin");
            http.ignoreSSLIssues();
            return http;
        }

        private final String basicAuth() {
            StringBuilder stringBuilder = new StringBuilder().append("Basic ");
            Base64.Encoder encoder = Base64.getEncoder();
            String string = "admin:admin";
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            return stringBuilder.append(encoder.encodeToString(byArray)).toString();
        }

        @JvmStatic
        @NotNull
        public final HttpRequest.Builder doRequest(@NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            HttpRequest.Builder builder = HttpRequest.newBuilder(new URI(url)).version(HttpClient.Version.HTTP_1_1).header("Authorization", this.basicAuth()).timeout(Duration.of(3L, ChronoUnit.MINUTES));
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"HttpRequest.newBuilder(U\u2026f(3, ChronoUnit.MINUTES))");
            return builder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @JvmStatic
        public final int findFreePort() {
            ServerSocket socket = null;
            socket = new ServerSocket(0);
            socket.setReuseAddress(true);
            int port = socket.getLocalPort();
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            int n = port;
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return n;
            catch (Exception exception) {
                try {
                    ServerSocket serverSocket = socket;
                    if (serverSocket != null) {
                        serverSocket.close();
                    }
                }
                catch (Exception exception2) {}
                catch (Throwable throwable) {
                    try {
                        ServerSocket serverSocket = socket;
                        if (serverSocket != null) {
                            serverSocket.close();
                        }
                    }
                    catch (Exception exception3) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            throw (Throwable)new IllegalStateException("Could not find a free TCP/IP port to start Integration Test Server");
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

