/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.util;

import ai.digital.integration.server.domain.MqParameters;
import ai.digital.integration.server.util.DeployServerUtil;
import ai.digital.integration.server.util.DockerComposeUtil;
import ai.digital.integration.server.util.FileUtil;
import ai.digital.integration.server.util.PropertyUtil;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lai/digital/integration/server/util/MqUtil;", "", "()V", "Companion", "integration-server-gradle-plugin"})
public final class MqUtil {
    @NotNull
    private static final String RABBITMQ;
    @NotNull
    private static final String ACTIVEMQ;
    @NotNull
    private static final MqParameters rabbitmqPararms;
    @NotNull
    private static final MqParameters activemqPararms;
    @NotNull
    public static final Companion Companion;

    static {
        Companion = new Companion(null);
        RABBITMQ = "rabbitmq";
        ACTIVEMQ = "activemq";
        rabbitmqPararms = new MqParameters("com.rabbitmq.jms:rabbitmq-jms", "com.rabbitmq.jms.admin.RMQConnectionFactory", null, "guest", "guest");
        activemqPararms = new MqParameters("org.apache.activemq:activemq-client", "org.apache.activemq.ActiveMQConnectionFactory", null, "admin", "admin");
    }

    @NotNull
    public static final String getRABBITMQ() {
        Companion companion = Companion;
        return RABBITMQ;
    }

    @NotNull
    public static final String getACTIVEMQ() {
        Companion companion = Companion;
        return ACTIVEMQ;
    }

    @JvmStatic
    @NotNull
    public static final String getMqDirectory(@NotNull Project project) {
        return Companion.getMqDirectory(project);
    }

    @JvmStatic
    @NotNull
    public static final String mqName(@NotNull Project project) {
        return Companion.mqName(project);
    }

    @JvmStatic
    @Nullable
    public static final Integer mqPort(@NotNull Project project) {
        return Companion.mqPort(project);
    }

    @JvmStatic
    @NotNull
    public static final String getMqRelativePath(@NotNull Project project) {
        return Companion.getMqRelativePath(project);
    }

    @JvmStatic
    @NotNull
    public static final MqParameters detectMqDependency(@NotNull String mq) {
        return Companion.detectMqDependency(mq);
    }

    @JvmStatic
    @NotNull
    public static final Path getResolvedDockerFile(@NotNull Project project) {
        return Companion.getResolvedDockerFile(project);
    }

    @NotNull
    public static final MqParameters getRabbitmqPararms() {
        Companion companion = Companion;
        return rabbitmqPararms;
    }

    @NotNull
    public static final MqParameters getActivemqPararms() {
        Companion companion = Companion;
        return activemqPararms;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0004H\u0007J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u0010\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u0010\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u0017\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0016\u001a\u00020\u0017H\u0007\u00a2\u0006\u0002\u0010\u001eR\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\t\u0010\u0002\u001a\u0004\b\n\u0010\u0007R\u001c\u0010\u000b\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\u0002\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0011\u0010\u0002\u001a\u0004\b\u0012\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lai/digital/integration/server/util/MqUtil$Companion;", "", "()V", "ACTIVEMQ", "", "getACTIVEMQ$annotations", "getACTIVEMQ", "()Ljava/lang/String;", "RABBITMQ", "getRABBITMQ$annotations", "getRABBITMQ", "activemqPararms", "Lai/digital/integration/server/domain/MqParameters;", "getActivemqPararms$annotations", "getActivemqPararms", "()Lai/digital/integration/server/domain/MqParameters;", "rabbitmqPararms", "getRabbitmqPararms$annotations", "getRabbitmqPararms", "detectMqDependency", "mq", "getMqDirectory", "project", "Lorg/gradle/api/Project;", "getMqRelativePath", "getResolvedDockerFile", "Ljava/nio/file/Path;", "mqName", "mqPort", "", "(Lorg/gradle/api/Project;)Ljava/lang/Integer;", "integration-server-gradle-plugin"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void getRABBITMQ$annotations() {
        }

        @NotNull
        public final String getRABBITMQ() {
            return RABBITMQ;
        }

        @JvmStatic
        public static /* synthetic */ void getACTIVEMQ$annotations() {
        }

        @NotNull
        public final String getACTIVEMQ() {
            return ACTIVEMQ;
        }

        @JvmStatic
        @NotNull
        public final String getMqDirectory(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return FileUtil.Companion.toPathString(DeployServerUtil.Companion.getServerDistFolderPath(project), "mq");
        }

        @JvmStatic
        @NotNull
        public final String mqName(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return String.valueOf(PropertyUtil.Companion.resolveValue(project, "mq", this.getRABBITMQ()));
        }

        @JvmStatic
        @Nullable
        public final Integer mqPort(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return PropertyUtil.Companion.resolveIntValue(project, "mqPort", null);
        }

        @JvmStatic
        @NotNull
        public final String getMqRelativePath(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return "mq/docker-compose_" + this.mqName(project) + ".yaml";
        }

        @JvmStatic
        @NotNull
        public final MqParameters detectMqDependency(@NotNull String mq) {
            Intrinsics.checkNotNullParameter((Object)mq, (String)"mq");
            String string = mq;
            return Intrinsics.areEqual((Object)string, (Object)this.getRABBITMQ()) ? this.getRabbitmqPararms() : (Intrinsics.areEqual((Object)string, (Object)this.getACTIVEMQ()) ? this.getActivemqPararms() : this.getRabbitmqPararms());
        }

        @JvmStatic
        @NotNull
        public final Path getResolvedDockerFile(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Path resultComposeFilePath = DockerComposeUtil.Companion.getResolvedDockerPath(project, this.getMqRelativePath(project));
            File mqTemplate = resultComposeFilePath.toFile();
            int port = Intrinsics.areEqual((Object)this.mqName(project), (Object)this.getRABBITMQ()) ? 5672 : 61616;
            Integer resolvedMqPort = PropertyUtil.Companion.resolveIntValue(project, "mqPort", port);
            File file = mqTemplate;
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"mqTemplate");
            String configuredTemplate = StringsKt.replace$default((String)StringsKt.replace$default((String)FilesKt.readText$default((File)file, null, (int)1, null), (String)"RABBITMQ_PORT2", (String)(resolvedMqPort + ":5672"), (boolean)false, (int)4, null), (String)"ACTIVEMQ_PORT2", (String)(resolvedMqPort + ":61616"), (boolean)false, (int)4, null);
            FilesKt.writeText$default((File)mqTemplate, (String)configuredTemplate, null, (int)2, null);
            return resultComposeFilePath;
        }

        @JvmStatic
        public static /* synthetic */ void getRabbitmqPararms$annotations() {
        }

        @NotNull
        public final MqParameters getRabbitmqPararms() {
            return rabbitmqPararms;
        }

        @JvmStatic
        public static /* synthetic */ void getActivemqPararms$annotations() {
        }

        @NotNull
        public final MqParameters getActivemqPararms() {
            return activemqPararms;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

