/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.tasks.database;

import ai.digital.integration.server.common.domain.DbParameters;
import ai.digital.integration.server.common.util.DbConfigurationUtil;
import ai.digital.integration.server.common.util.DbUtil;
import ai.digital.integration.server.common.util.PostgresDbUtil;
import ai.digital.integration.server.deploy.util.DeployExtensionUtil;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.xml.FlatXmlDataSet;
import org.dbunit.dataset.xml.FlatXmlDataSetBuilder;
import org.dbunit.operation.DatabaseOperation;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0002J\u001a\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0002J\b\u0010\n\u001a\u00020\u000bH\u0007\u00a8\u0006\r"}, d2={"Lai/digital/integration/server/common/tasks/database/ImportDbUnitDataTask;", "Lorg/gradle/api/DefaultTask;", "()V", "configureDataSet", "Lorg/dbunit/dataset/xml/FlatXmlDataSet;", "getConfiguration", "Lkotlin/Triple;", "", "getDbPropValue", "propName", "runImport", "", "Companion", "integration-server-gradle-plugin"})
public abstract class ImportDbUnitDataTask
extends DefaultTask {
    @NotNull
    public static final String NAME = "importDbUnitData";
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final String getDbPropValue(String propName) {
        TreeNode dbConfig;
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        TreeNode treeNode = dbConfig = DbUtil.Companion.dbConfig(project);
        if (treeNode != null) {
            TreeNode treeNode2 = treeNode;
            boolean bl = false;
            boolean bl2 = false;
            TreeNode config = treeNode2;
            boolean bl3 = false;
            TreeNode treeNode3 = config.get("xl.repository").get("database").get(propName);
            if (treeNode3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.fasterxml.jackson.databind.node.TextNode");
            }
            String string = ((TextNode)treeNode3).textValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(config.get(\"xl.reposito\u2026 as TextNode).textValue()");
            return string;
        }
        return "";
    }

    private final Triple<String, String, String> getConfiguration() {
        String username = this.getDbPropValue("db-username");
        String password = this.getDbPropValue("db-password");
        String url = this.getDbPropValue("db-url");
        return new Triple((Object)username, (Object)password, (Object)url);
    }

    private final FlatXmlDataSet configureDataSet() {
        FlatXmlDataSetBuilder provider = new FlatXmlDataSetBuilder();
        provider.setColumnSensing(true);
        provider.setCaseSensitiveTableNames(true);
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        String destinationDir = ((Object)project.getBuildDir().toPath().resolve("integration-server").toAbsolutePath()).toString();
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        String version = DeployExtensionUtil.Companion.getExtension(project2).getXldIsDataVersion();
        Path dataFile = Paths.get(destinationDir + "/xld-is-data-" + version + "-repository/data.xml", new String[0]);
        return provider.build((InputStream)new FileInputStream(dataFile.toFile()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public final void runImport() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        String dbname = DbUtil.Companion.databaseName(project);
        DbParameters dbDependency = DbUtil.Companion.detectDbDependencies(dbname);
        Triple<String, String, String> dbConfig = this.getConfiguration();
        Properties properties = DbConfigurationUtil.Companion.connectionProperties((String)dbConfig.getFirst(), (String)dbConfig.getSecond());
        String string = dbDependency.getDriverClass();
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            string2 = "";
        }
        Connection driverConnection = DbConfigurationUtil.Companion.createDriverConnection(string2, (String)dbConfig.getThird(), properties);
        DatabaseConnection connection = DbConfigurationUtil.Companion.configureConnection(driverConnection, dbDependency);
        try {
            FlatXmlDataSet dataSet = this.configureDataSet();
            DatabaseOperation.CLEAN_INSERT.execute((IDatabaseConnection)connection, (IDataSet)dataSet);
            if (Intrinsics.areEqual((Object)dbname, (Object)"postgres-10")) {
                Project project2 = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
                PostgresDbUtil.Companion.resetSequences(project2, driverConnection);
            }
        }
        finally {
            connection.close();
            driverConnection.close();
        }
    }

    public ImportDbUnitDataTask() {
        this.setGroup("Integration Server");
        this.dependsOn(new Object[]{"downloadAndExtractDbUnitData"});
        this.onlyIf((Spec)new Spec<Task>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isSatisfiedBy(Task it) {
                Project project = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                if (DbUtil.Companion.isDerby(project)) return false;
                Project project2 = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
                if (DeployExtensionUtil.Companion.getExtension(project2).getXldIsDataVersion() == null) return false;
                return true;
            }
        });
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/digital/integration/server/common/tasks/database/ImportDbUnitDataTask$Companion;", "", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

