/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.tasks.server;

import ai.digital.integration.server.common.domain.Server;
import ai.digital.integration.server.common.util.DbUtil;
import ai.digital.integration.server.common.util.ProcessUtil;
import ai.digital.integration.server.deploy.internals.DeployServerUtil;
import ai.digital.integration.server.deploy.internals.EnvironmentUtil;
import ai.digital.integration.server.deploy.internals.SatelliteUtil;
import ai.digital.integration.server.deploy.internals.ShutdownUtil;
import ai.digital.integration.server.deploy.internals.WorkerUtil;
import java.io.File;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;
import org.gradle.kotlin.dsl.GroovyInteroperabilityKt;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\n\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\u0004H\u0007J\b\u0010\f\u001a\u00020\u0004H\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0011"}, d2={"Lai/digital/integration/server/deploy/tasks/server/StartServerInstanceTask;", "Lorg/gradle/api/DefaultTask;", "()V", "allowToWriteMountedHostFolders", "", "getBinDir", "Ljava/io/File;", "hasToBeStartedFromClasspath", "", "server", "Lai/digital/integration/server/common/domain/Server;", "launch", "maybeTearDown", "start", "Ljava/lang/Process;", "startServer", "Companion", "integration-server-gradle-plugin"})
public class StartServerInstanceTask
extends DefaultTask {
    @NotNull
    public static final String NAME = "startServerInstance";
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final File getBinDir() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        return Paths.get(DeployServerUtil.Companion.getServerWorkingDir(project), "bin").toFile();
    }

    private final Process startServer(Server server) {
        File file;
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        project.getLogger().lifecycle("Launching server");
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        Map<String, String> environment = EnvironmentUtil.Companion.getServerEnv(project2, server);
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
        project3.getLogger().info("Starting server with environment: " + environment);
        Pair[] pairArray = new Pair[6];
        pairArray[0] = TuplesKt.to((Object)"command", (Object)"run");
        pairArray[1] = TuplesKt.to((Object)"discardIO", (Object)(server.getStdoutFileName() == null ? 1 : 0));
        if (server.getStdoutFileName() != null) {
            StringBuilder stringBuilder = new StringBuilder();
            Project project4 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"project");
            file = new File(stringBuilder.append(DeployServerUtil.Companion.getLogDir(project4).toString()).append("/").append(server.getStdoutFileName()).toString());
        } else {
            file = null;
        }
        pairArray[2] = TuplesKt.to((Object)"redirectTo", (Object)file);
        pairArray[3] = TuplesKt.to((Object)"environment", environment);
        pairArray[4] = TuplesKt.to((Object)"params", (Object)CollectionsKt.listOf((Object)"-force-upgrades"));
        pairArray[5] = TuplesKt.to((Object)"workDir", (Object)this.getBinDir());
        Map map2 = MapsKt.mapOf((Pair[])pairArray);
        Process process = ProcessUtil.Companion.exec(map2);
        Project project5 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project5, (String)"project");
        project5.getLogger().lifecycle("Launched server on PID [" + String.valueOf(process.pid()) + "] with command [" + process.info().commandLine().orElse("") + "].");
        return process;
    }

    private final boolean hasToBeStartedFromClasspath(Server server) {
        return server.getRuntimeDirectory() != null;
    }

    private final Process start(Server server) {
        Process process;
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        if (!DeployServerUtil.Companion.isDockerBased(project)) {
            this.maybeTearDown();
            if (this.hasToBeStartedFromClasspath(server)) {
                Project project2 = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
                process = DeployServerUtil.Companion.startServerFromClasspath(project2);
            } else {
                process = this.startServer(server);
            }
        } else {
            this.getProject().exec((Action)new Action<ExecSpec>(this){
                final /* synthetic */ StartServerInstanceTask this$0;

                public final void execute(ExecSpec it) {
                    ExecSpec execSpec = it;
                    Intrinsics.checkNotNullExpressionValue((Object)execSpec, (String)"it");
                    execSpec.setExecutable("docker-compose");
                    Object[] objectArray = new String[4];
                    objectArray[0] = "-f";
                    Project project = this.this$0.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                    String string = DeployServerUtil.Companion.getResolvedDockerFile(project).toFile().toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DeployServerUtil.getReso\u2026ject).toFile().toString()");
                    objectArray[1] = string;
                    objectArray[2] = "up";
                    objectArray[3] = "-d";
                    it.setArgs(CollectionsKt.listOf((Object[])objectArray));
                }
                {
                    this.this$0 = startServerInstanceTask;
                }
            });
            process = null;
        }
        return process;
    }

    private final void maybeTearDown() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        ShutdownUtil.Companion.shutdownServer(project);
    }

    private final void allowToWriteMountedHostFolders() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        DeployServerUtil.Companion.grantPermissionsToIntegrationServerFolder(project);
    }

    @TaskAction
    public final void launch() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        Server server = DeployServerUtil.Companion.getServer(project);
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        project2.getLogger().lifecycle("About to launch Deploy Server on port " + String.valueOf(server.getHttpPort()) + ".");
        this.allowToWriteMountedHostFolders();
        Process process = this.start(server);
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
        DeployServerUtil.Companion.waitForBoot(project3, process);
    }

    public StartServerInstanceTask() {
        this.setGroup("Integration Server");
        Object[] objectArray = new String[14];
        objectArray[0] = "applicationConfigurationOverride";
        objectArray[1] = "centralConfiguration";
        objectArray[2] = "checkUILibVersions";
        objectArray[3] = "copyCliBuildArtifacts";
        objectArray[4] = "copyServerFolders";
        objectArray[5] = "copyServerBuildArtifacts";
        objectArray[6] = "serverCopyOverlays";
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        objectArray[7] = DbUtil.Companion.isDerby(project) ? "derbyStart" : "databaseStart";
        objectArray[8] = "downloadAndExtractServer";
        objectArray[9] = "prepareDatabase";
        objectArray[10] = "prepareDeploy";
        objectArray[11] = "setLogbackLevels";
        objectArray[12] = "startMq";
        objectArray[13] = "serverYamlPatch";
        final List dependencies = CollectionsKt.mutableListOf((Object[])objectArray);
        this.configure(GroovyInteroperabilityKt.closureOf((Object)((Object)this), (Function1)((Function1)new Function1<StartServerInstanceTask, Unit>(){

            public final void invoke(@NotNull StartServerInstanceTask $this$closureOf) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$closureOf), (String)"$receiver");
                Project project = $this$closureOf.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                if (DeployServerUtil.Companion.isTls(project)) {
                    dependencies.add("tlsApplicationConfigurationOverride");
                }
                Project project2 = $this$closureOf.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
                if (DeployServerUtil.Companion.isAkkaSecured(project2)) {
                    dependencies.add("generateSecureAkkaKeys");
                }
                Project project3 = $this$closureOf.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
                if (DeployServerUtil.Companion.isAkkaSecured(project3)) {
                    dependencies.add("generateSecureAkkaKeys");
                }
                $this$closureOf.dependsOn(new Object[]{dependencies});
                Project project4 = $this$closureOf.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"project");
                if (!DeployServerUtil.Companion.isDockerBased(project4)) {
                    Project project5 = $this$closureOf.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project5, (String)"project");
                    if (WorkerUtil.Companion.hasWorkers(project5)) {
                        $this$closureOf.finalizedBy(new Object[]{"startWorkers"});
                    }
                    Project project6 = $this$closureOf.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project6, (String)"project");
                    if (SatelliteUtil.Companion.hasSatellites(project6)) {
                        $this$closureOf.finalizedBy(new Object[]{"startSatellite"});
                    }
                }
                $this$closureOf.finalizedBy(new Object[]{"importDbUnitData"});
                $this$closureOf.finalizedBy(new Object[]{"runDevOpsAsCode"});
                $this$closureOf.finalizedBy(new Object[]{"runDatasetGeneration"});
                $this$closureOf.finalizedBy(new Object[]{"runCli"});
            }
        })));
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/digital/integration/server/deploy/tasks/server/StartServerInstanceTask$Companion;", "", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

