/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.tls;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.process.ExecResult;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010!\u001a\u0004\u0018\u00010\"2\u000e\u0010#\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\r2\u0006\u0010$\u001a\u00020%J\b\u0010&\u001a\u00020\u001cH&J\b\u0010'\u001a\u00020%H&R \u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR \u0010\t\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR$\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\r8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R \u0010\u0012\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0006\"\u0004\b\u0014\u0010\bR\u001e\u0010\u0015\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0006\"\u0004\b\u0017\u0010\bR\u001e\u0010\u0018\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0006\"\u0004\b\u001a\u0010\bR \u0010\u001b\u001a\u0004\u0018\u00010\u001c8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u0006("}, d2={"Lai/digital/integration/server/common/tls/KeytoolTask;", "Lorg/gradle/api/DefaultTask;", "()V", "keyname", "", "getKeyname", "()Ljava/lang/String;", "setKeyname", "(Ljava/lang/String;)V", "keypass", "getKeypass", "setKeypass", "params", "", "getParams", "()Ljava/util/List;", "setParams", "(Ljava/util/List;)V", "storepass", "getStorepass", "setStorepass", "type", "getType", "setType", "typeExtension", "getTypeExtension", "setTypeExtension", "workDir", "Ljava/io/File;", "getWorkDir", "()Ljava/io/File;", "setWorkDir", "(Ljava/io/File;)V", "execTask", "Lorg/gradle/process/ExecResult;", "customParams", "skipExec", "", "getOutputFile", "skipIfOutputFileExists", "integration-server-gradle-plugin"})
public abstract class KeytoolTask
extends DefaultTask {
    @Input
    @Nullable
    private String keyname;
    @InputDirectory
    @Nullable
    private File workDir;
    @Input
    @NotNull
    private List<String> params;
    @Input
    @Nullable
    private String keypass;
    @Input
    @Nullable
    private String storepass;
    @Input
    @NotNull
    private String type;
    @Input
    @NotNull
    private String typeExtension;

    @Nullable
    public final String getKeyname() {
        return this.keyname;
    }

    public final void setKeyname(@Nullable String string) {
        this.keyname = string;
    }

    @Nullable
    public final File getWorkDir() {
        return this.workDir;
    }

    public final void setWorkDir(@Nullable File file) {
        this.workDir = file;
    }

    @NotNull
    protected final List<String> getParams() {
        return this.params;
    }

    protected final void setParams(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.params = list;
    }

    @Nullable
    public final String getKeypass() {
        return this.keypass;
    }

    public final void setKeypass(@Nullable String string) {
        this.keypass = string;
    }

    @Nullable
    public final String getStorepass() {
        return this.storepass;
    }

    public final void setStorepass(@Nullable String string) {
        this.storepass = string;
    }

    @NotNull
    public final String getType() {
        return this.type;
    }

    public final void setType(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.type = string;
    }

    @NotNull
    public final String getTypeExtension() {
        return this.typeExtension;
    }

    public final void setTypeExtension(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.typeExtension = string;
    }

    @NotNull
    public abstract File getOutputFile();

    public abstract boolean skipIfOutputFileExists();

    @Nullable
    public final ExecResult execTask(@NotNull List<String> customParams, boolean skipExec) {
        ExecResult execResult;
        Intrinsics.checkNotNullParameter(customParams, (String)"customParams");
        ArrayList strings = new ArrayList(customParams);
        if (this.keypass != null && Intrinsics.areEqual((Object)this.type, (Object)"pkcs12") ^ true) {
            strings.addAll(CollectionsKt.listOf((Object[])new String[]{"-keypass", this.keypass}));
        }
        if (this.storepass != null) {
            strings.addAll(CollectionsKt.listOf((Object[])new String[]{"-storepass", this.storepass}));
        }
        if (skipExec && this.getOutputFile().exists()) {
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
            project.getLogger().lifecycle("Skipping keytool with args: " + CollectionsKt.joinToString$default((Iterable)strings, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
            execResult = null;
        } else {
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
            project.getLogger().lifecycle("Executing keytool with args: " + CollectionsKt.joinToString$default((Iterable)strings, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
            execResult = this.getProject().exec((Action)new Action<ExecSpec>(this, strings){
                final /* synthetic */ KeytoolTask this$0;
                final /* synthetic */ ArrayList $strings;

                public final void execute(ExecSpec it) {
                    ExecSpec execSpec = it;
                    Intrinsics.checkNotNullExpressionValue((Object)execSpec, (String)"it");
                    execSpec.setExecutable("keytool");
                    it.setArgs((List)this.$strings);
                    it.setWorkingDir(this.this$0.getWorkDir());
                    it.setIgnoreExitValue(true);
                }
                {
                    this.this$0 = keytoolTask;
                    this.$strings = arrayList;
                }
            });
        }
        return execResult;
    }

    public KeytoolTask() {
        this.setGroup("Integration Server");
        this.mustRunAfter(new Object[]{"serverCopyOverlays"});
        this.mustRunAfter(new Object[]{"centralConfiguration"});
        this.doFirst((Action)new Action<Task>(){

            public final void execute(Task it) {
                ArrayList customParams = new ArrayList(this.getParams());
                ExecResult result = this.execTask(customParams, this.skipIfOutputFileExists());
                if (result != null && result.getExitValue() == 1) {
                    throw (Throwable)new RuntimeException("Running keytool with params: " + CollectionsKt.joinToString$default((Iterable)customParams, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) + " was not successfully executed.");
                }
            }
        });
        this.params = CollectionsKt.emptyList();
        this.type = "pkcs12";
        this.typeExtension = "p12";
    }
}

