/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.tasks.cli;

import ai.digital.integration.server.deploy.domain.Cli;
import ai.digital.integration.server.deploy.internals.CliUtil;
import ai.digital.integration.server.deploy.internals.DeployServerUtil;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\tH\u0007R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lai/digital/integration/server/deploy/tasks/cli/RunCliTask;", "Lorg/gradle/api/DefaultTask;", "()V", "secure", "Lorg/gradle/api/provider/Property;", "", "getSecure", "()Lorg/gradle/api/provider/Property;", "executeScripts", "", "cli", "Lai/digital/integration/server/deploy/domain/Cli;", "launch", "Companion", "integration-server-gradle-plugin"})
public abstract class RunCliTask
extends DefaultTask {
    @NotNull
    public static final String NAME = "runCli";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Input
    @Option(option="security", description="Use true when TLS is enabled on the server side.")
    @Optional
    @NotNull
    public abstract Property<Boolean> getSecure();

    private final void executeScripts(Cli cli) {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        project.getLogger().lifecycle("Executing cli scripts ....");
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        List<File> list = cli.getFilesToExecute();
        Object object = this.getSecure().getOrElse((Object)false);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"secure.getOrElse(false)");
        CliUtil.Companion.executeScripts(project2, list, "cli", (Boolean)object);
    }

    @TaskAction
    public final void launch() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        project.getLogger().lifecycle("Running a CLI provision script on the Deploy server.");
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        this.executeScripts(CliUtil.Companion.getCli(project2));
    }

    public RunCliTask() {
        this.dependsOn(new Object[]{"cliCleanDefaultExt"});
        this.dependsOn(new Object[]{"cliOverlays"});
        this.dependsOn(new Object[]{"downloadAndExtractCli"});
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        if (DeployServerUtil.Companion.isTls(project)) {
            this.dependsOn(new Object[]{"tlsApplicationConfigurationOverride"});
        }
        this.setGroup("Integration Server");
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/digital/integration/server/deploy/tasks/cli/RunCliTask$Companion;", "", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

