/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.tasks.tls;

import ai.digital.integration.server.common.domain.Tls;
import ai.digital.integration.server.common.util.PropertiesUtil;
import ai.digital.integration.server.common.util.TlsUtil;
import ai.digital.integration.server.deploy.internals.DeployServerUtil;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;
import org.gradle.kotlin.dsl.GroovyInteroperabilityKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\u0012\u0010\u0005\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\u0012\u0010\b\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002\u00a8\u0006\n"}, d2={"Lai/digital/integration/server/deploy/tasks/tls/TlsApplicationConfigurationOverrideTask;", "Lorg/gradle/api/DefaultTask;", "()V", "run", "", "updateDeployitConf", "tls", "Lai/digital/integration/server/common/domain/Tls;", "updateWrapperConf", "Companion", "integration-server-gradle-plugin"})
public class TlsApplicationConfigurationOverrideTask
extends DefaultTask {
    @NotNull
    public static final String NAME = "tlsApplicationConfigurationOverride";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @TaskAction
    public final void run() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        Tls tls = TlsUtil.Companion.getTls(project, DeployServerUtil.Companion.getServerWorkingDir(project2));
        this.updateDeployitConf(tls);
        this.updateWrapperConf(tls);
    }

    private final void updateDeployitConf(Tls tls) {
        File deployitConf;
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        project.getLogger().lifecycle("Configurations TLS overriding for deployit.conf.");
        Project project2 = this.getProject();
        StringBuilder stringBuilder = new StringBuilder();
        Tls tls2 = tls;
        Intrinsics.checkNotNull((Object)tls2);
        File file = deployitConf = project2.file((Object)stringBuilder.append(tls2.confWorkDir()).append("/deployit.conf").toString());
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"deployitConf");
        Properties properties = PropertiesUtil.Companion.readPropertiesFile(file);
        ((Map)properties).put("ssl", String.valueOf(true));
        ((Map)properties).put("keystore.type", "pkcs12");
        ((Map)properties).put("keystore.password", tls.getKeyStorePassword());
        if (Intrinsics.areEqual((Object)"pkcs12", (Object)"pkcs12") ^ true) {
            ((Map)properties).put("keystore.keypassword", tls.getKeyPassword());
        }
        ((Map)properties).put("keystore.path", tls.keyStoreFile().getAbsolutePath());
        PropertiesUtil.Companion.writePropertiesFile(deployitConf, properties);
    }

    private final void updateWrapperConf(Tls tls) {
        File wrapperConf;
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        project.getLogger().lifecycle("Configurations TLS overriding for xld-wrapper.conf.common.");
        Project project2 = this.getProject();
        StringBuilder stringBuilder = new StringBuilder();
        Tls tls2 = tls;
        Intrinsics.checkNotNull((Object)tls2);
        File file = wrapperConf = project2.file((Object)stringBuilder.append(tls2.confWorkDir().toString()).append("/deployit.conf").toString());
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"wrapperConf");
        Properties properties = PropertiesUtil.Companion.readPropertiesFile(file);
        for (int pos = 0; pos < 20 && properties.containsKey("wrapper.java.additional." + pos); ++pos) {
        }
        PropertiesUtil.Companion.writePropertiesFile(wrapperConf, properties);
    }

    public TlsApplicationConfigurationOverrideTask() {
        this.setGroup("Integration Server");
        this.configure(GroovyInteroperabilityKt.closureOf((Object)((Object)this), (Function1)1.INSTANCE));
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/digital/integration/server/deploy/tasks/tls/TlsApplicationConfigurationOverrideTask$Companion;", "", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

