/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.util;

import ai.digital.integration.server.common.domain.Database;
import ai.digital.integration.server.common.domain.DbParameters;
import ai.digital.integration.server.common.util.DbUtil;
import ai.digital.integration.server.common.util.DockerComposeUtil;
import ai.digital.integration.server.common.util.HTTPUtil;
import ai.digital.integration.server.common.util.PropertyUtil;
import ai.digital.integration.server.common.util.YamlFileUtil;
import ai.digital.integration.server.deploy.internals.DeployExtensionUtil;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lai/digital/integration/server/common/util/DbUtil;", "", "()V", "Companion", "integration-server-gradle-plugin"})
public final class DbUtil {
    @NotNull
    public static final String POSTGRES = "postgres-10";
    @NotNull
    public static final String POSTGRES12 = "postgres-12";
    @NotNull
    public static final String ORACLE19 = "oracle-19c-se";
    @NotNull
    public static final String MYSQL = "mysql";
    @NotNull
    public static final String MYSQL8 = "mysql-8";
    @NotNull
    public static final String MSSQL = "mssql";
    @NotNull
    public static final String DERBY = "derby";
    @NotNull
    public static final String DERBY_NETWORK = "derby-network";
    @NotNull
    public static final String DERBY_INMEMORY = "derby-inmemory";
    private static final int randomDatabasePort;
    private static final DbParameters postgresParams;
    private static final DbParameters mysqlParams;
    private static final DbParameters oracle19Params;
    private static final DbParameters mssqlParams;
    private static final DbParameters derbyParams;
    private static final DbParameters derbyNetworkParams;
    @NotNull
    public static final Companion Companion;

    static {
        Companion = new Companion(null);
        randomDatabasePort = HTTPUtil.Companion.findFreePort();
        postgresParams = new DbParameters("org.postgresql:postgresql", "org.postgresql.Driver", "org.dbunit.ext.postgresql.PostgresqlDataTypeFactory", null, "\"?\"");
        mysqlParams = new DbParameters("mysql:mysql-connector-java", "com.mysql.jdbc.Driver", "org.dbunit.ext.mysql.MySqlDataTypeFactory", "org.dbunit.ext.mysql.MySqlMetadataHandler", "`?`");
        oracle19Params = new DbParameters("com.oracle.database.jdbc:ojdbc11", "oracle.jdbc.OracleDriver", "org.dbunit.ext.oracle.OracleDataTypeFactory", null, "\"?\"");
        mssqlParams = new DbParameters("com.microsoft.sqlserver:mssql-jdbc", "com.microsoft.sqlserver.jdbc.SQLServerDriver", "org.dbunit.ext.mssql.MsSqlDataTypeFactory", null, "\"?\"");
        derbyParams = new DbParameters("org.apache.derby:derby", null, null, null, "\"?\"");
        derbyNetworkParams = new DbParameters("org.apache.derby:derbyclient", null, null, null, "\"?\"");
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0004J\u000e\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0018\u001a\u00020\u0019J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u000e\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u0004J\u000e\u0010\"\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019J\u0018\u0010#\u001a\u00020$2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010%\u001a\u00020$H\u0002J\u000e\u0010&\u001a\u00020$2\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010'\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010(\u001a\u00020\u0004J\u000e\u0010)\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010*\u001a\u00020+2\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010,\u001a\u00020\u00172\u0006\u0010-\u001a\u00020+2\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u0004J\u000e\u0010.\u001a\u00020/2\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u00101\u001a\u00020/2\u0006\u0010\u0018\u001a\u00020\u0019R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lai/digital/integration/server/common/util/DbUtil$Companion;", "", "()V", "DERBY", "", "DERBY_INMEMORY", "DERBY_NETWORK", "MSSQL", "MYSQL", "MYSQL8", "ORACLE19", "POSTGRES", "POSTGRES12", "derbyNetworkParams", "Lai/digital/integration/server/common/domain/DbParameters;", "derbyParams", "mssqlParams", "mysqlParams", "oracle19Params", "postgresParams", "randomDatabasePort", "", "assertNotDerby", "", "project", "Lorg/gradle/api/Project;", "message", "databaseName", "dbConfig", "Lcom/fasterxml/jackson/core/TreeNode;", "dbConfigStream", "Ljava/io/InputStream;", "detectDbDependencies", "db", "dockerComposeFileName", "enrichDatabase", "Lai/digital/integration/server/common/domain/Database;", "database", "getDatabase", "getDbPropValue", "propName", "getPort", "getResolveDbFilePath", "Ljava/nio/file/Path;", "getResolvedDBDockerComposeFile", "resultComposeFilePath", "isDerby", "", "name", "isDerbyNetwork", "integration-server-gradle-plugin"})
    public static final class Companion {
        @NotNull
        public final String databaseName(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            return String.valueOf(PropertyUtil.Companion.resolveValue(project, "database", DbUtil.DERBY_INMEMORY));
        }

        private final InputStream dbConfigStream(Project project) {
            String dbname = this.databaseName(project);
            return ((Object)((Object)dbConfigStream.1.INSTANCE)).getClass().getClassLoader().getResourceAsStream("database-conf/deploy-repository.yaml." + dbname);
        }

        public final boolean isDerby(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            String dbname = this.databaseName(project);
            return this.isDerby(dbname);
        }

        public final boolean isDerby(@NotNull String name) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            return Intrinsics.areEqual((Object)name, (Object)DbUtil.DERBY_NETWORK) || Intrinsics.areEqual((Object)name, (Object)DbUtil.DERBY_INMEMORY) || Intrinsics.areEqual((Object)name, (Object)DbUtil.DERBY);
        }

        public final boolean isDerbyNetwork(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            String dbName = this.databaseName(project);
            return Intrinsics.areEqual((Object)dbName, (Object)DbUtil.DERBY_NETWORK) || Intrinsics.areEqual((Object)dbName, (Object)DbUtil.DERBY);
        }

        public final void assertNotDerby(@NotNull Project project, @NotNull String message) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            String dbname = this.databaseName(project);
            if (this.isDerby(dbname)) {
                throw (Throwable)new GradleException(message);
            }
        }

        @Nullable
        public final TreeNode dbConfig(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            InputStream from2 = this.dbConfigStream(project);
            return from2 != null ? YamlFileUtil.Companion.readTree(from2) : null;
        }

        @NotNull
        public final String getDbPropValue(@NotNull Project project, @NotNull String propName) {
            TreeNode dbConfig;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)propName, (String)"propName");
            TreeNode treeNode = dbConfig = this.dbConfig(project);
            if (treeNode != null) {
                TreeNode treeNode2 = treeNode;
                boolean bl = false;
                boolean bl2 = false;
                TreeNode config = treeNode2;
                boolean bl3 = false;
                TreeNode treeNode3 = config.get("xl.repository").get("database").get(propName);
                if (treeNode3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.fasterxml.jackson.databind.node.TextNode");
                }
                String string = ((TextNode)treeNode3).textValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(config.get(\"xl.reposito\u2026 as TextNode).textValue()");
                return string;
            }
            return "";
        }

        private final Database enrichDatabase(Project project, Database database) {
            boolean bl;
            database.setDatabasePort(project.hasProperty("databasePort") ? Integer.valueOf(String.valueOf(project.property("databasePort"))) : Integer.valueOf(randomDatabasePort));
            if (project.hasProperty("logSql")) {
                String string = String.valueOf(project.property("logSql"));
                boolean bl2 = false;
                String string2 = string;
                boolean bl3 = false;
                bl = Boolean.parseBoolean(string2);
            } else {
                bl = database.getLogSql();
            }
            database.setLogSql(bl);
            return database;
        }

        public final int getPort(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Integer n = this.getDatabase(project).getDatabasePort();
            return n != null ? n : randomDatabasePort;
        }

        @NotNull
        public final Database getDatabase(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Object object = DeployExtensionUtil.Companion.getExtension(project).getDatabase().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"DeployExtensionUtil.getE\u2026n(project).database.get()");
            Database database = (Database)object;
            return this.enrichDatabase(project, database);
        }

        @NotNull
        public final Path getResolveDbFilePath(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            String composeFileName = this.dockerComposeFileName(project);
            return DockerComposeUtil.Companion.getResolvedDockerPath(project, "database-compose/" + composeFileName);
        }

        @NotNull
        public final String dockerComposeFileName(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            String dbName = this.databaseName(project);
            return "docker-compose_" + dbName + ".yaml";
        }

        @NotNull
        public final DbParameters detectDbDependencies(@NotNull String db) {
            DbParameters dbParameters;
            Intrinsics.checkParameterIsNotNull((Object)db, (String)"db");
            switch (db) {
                case "derby": {
                    dbParameters = derbyNetworkParams;
                    break;
                }
                case "derby-inmemory": {
                    dbParameters = derbyParams;
                    break;
                }
                case "derby-network": {
                    dbParameters = derbyNetworkParams;
                    break;
                }
                case "mssql": {
                    dbParameters = mssqlParams;
                    break;
                }
                case "mysql-8": 
                case "mysql": {
                    dbParameters = mysqlParams;
                    break;
                }
                case "oracle-19c-se": {
                    dbParameters = oracle19Params;
                    break;
                }
                case "postgres-10": 
                case "postgres-12": {
                    dbParameters = postgresParams;
                    break;
                }
                default: {
                    dbParameters = derbyNetworkParams;
                }
            }
            return dbParameters;
        }

        public final void getResolvedDBDockerComposeFile(@NotNull Path resultComposeFilePath, @NotNull Project project) {
            File serverTemplate;
            Intrinsics.checkParameterIsNotNull((Object)resultComposeFilePath, (String)"resultComposeFilePath");
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            File file = serverTemplate = resultComposeFilePath.toFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"serverTemplate");
            String configuredTemplate = StringsKt.replace$default((String)FilesKt.readText((File)file, (Charset)Charsets.UTF_8), (String)"{{DB_PORT}}", (String)String.valueOf(this.getPort(project)), (boolean)false, (int)4, null);
            FilesKt.writeText$default((File)serverTemplate, (String)configuredTemplate, null, (int)2, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

