/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.tasks.provision;

import ai.digital.integration.server.common.domain.DevOpsAsCode;
import ai.digital.integration.server.common.domain.Server;
import ai.digital.integration.server.common.util.HTTPUtil;
import ai.digital.integration.server.deploy.internals.DeployServerUtil;
import ai.digital.integration.server.deploy.internals.EntryPointUrlUtil;
import ai.digital.integration.server.deploy.internals.WorkerUtil;
import java.io.File;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.Charsets;
import org.gradle.api.DefaultTask;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\u0018\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u000b"}, d2={"Lai/digital/integration/server/deploy/tasks/provision/RunDevOpsAsCodeTask;", "Lorg/gradle/api/DefaultTask;", "()V", "launch", "", "launchDevOpAsCodeScripts", "project", "Lorg/gradle/api/Project;", "server", "Lai/digital/integration/server/common/domain/Server;", "Companion", "integration-server-gradle-plugin"})
public class RunDevOpsAsCodeTask
extends DefaultTask {
    @NotNull
    public static final String NAME = "runDevOpsAsCode";
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final void launchDevOpAsCodeScripts(Project project, Server server) {
        if (server.getDevOpsAsCodes() != null) {
            NamedDomainObjectContainer<DevOpsAsCode> namedDomainObjectContainer = server.getDevOpsAsCodes();
            if (namedDomainObjectContainer != null) {
                Iterable $this$forEach$iv = (Iterable)namedDomainObjectContainer;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    DevOpsAsCode devOpsAsCode = (DevOpsAsCode)element$iv;
                    boolean bl = false;
                    if (devOpsAsCode.getDevOpAsCodeScript() != null) {
                        File file;
                        boolean bl2 = false;
                        boolean bl3 = false;
                        File script = file;
                        boolean bl4 = false;
                        HttpClient client = HttpClient.newHttpClient();
                        boolean bl5 = false;
                        List headers = new ArrayList();
                        Function2<String, String, Unit> $fun$addHeaders$1 = new Function2<String, String, Unit>(headers){
                            final /* synthetic */ List $headers;

                            public final void invoke(@NotNull String key, @Nullable String value) {
                                Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
                                if (value != null) {
                                    this.$headers.addAll(CollectionsKt.arrayListOf((Object[])new String[]{key, value}));
                                }
                            }
                            {
                                this.$headers = list;
                                super(2);
                            }
                        };
                        $fun$addHeaders$1.invoke("X-Xebialabs-Scm-Author", devOpsAsCode.getScmAuthor());
                        $fun$addHeaders$1.invoke("X-Xebialabs-Scm-Commit", devOpsAsCode.getScmCommit());
                        $fun$addHeaders$1.invoke("X-Xebialabs-Scm-Date", devOpsAsCode.getScmDate());
                        $fun$addHeaders$1.invoke("X-Xebialabs-Scm-Filename", devOpsAsCode.getScmFile());
                        $fun$addHeaders$1.invoke("X-Xebialabs-Scm-Message", devOpsAsCode.getScmMessage());
                        $fun$addHeaders$1.invoke("X-Xebialabs-Scm-Remote", devOpsAsCode.getScmRemote());
                        $fun$addHeaders$1.invoke("X-Xebialabs-Scm-Type", devOpsAsCode.getScmType());
                        HttpRequest.Builder builder = HTTPUtil.Companion.doRequest(EntryPointUrlUtil.Companion.composeUrl$default(EntryPointUrlUtil.Companion, project, "/deployit/devops-as-code/apply", false, 4, null));
                        SpreadBuilder spreadBuilder = new SpreadBuilder(3);
                        spreadBuilder.add((Object)"Content-Type");
                        spreadBuilder.add((Object)"text/vnd.yaml");
                        Collection $this$toTypedArray$iv = headers;
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv;
                        String[] stringArray = thisCollection$iv.toArray(new String[0]);
                        if (stringArray == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                        }
                        spreadBuilder.addSpread((Object)stringArray);
                        HttpRequest.Builder builder2 = builder.headers((String[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()]));
                        File file2 = script.toPath().toFile();
                        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"script.toPath().toFile()");
                        HttpRequest request = builder2.POST(HttpRequest.BodyPublishers.ofString(FilesKt.readText((File)file2, (Charset)Charsets.UTF_8))).build();
                        HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                        if (response.statusCode() == 200) {
                            project.getLogger().info("YAML " + devOpsAsCode.getDevOpAsCodeScript() + " has been applied.");
                            continue;
                        }
                        project.getLogger().error(response.body());
                    }
                }
            }
        }
    }

    @TaskAction
    public final void launch() {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        project.getLogger().lifecycle("Running Dev Ops as Code provision script on the Deploy server.");
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        Project project3 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
        this.launchDevOpAsCodeScripts(project2, DeployServerUtil.Companion.getServer(project3));
    }

    public RunDevOpsAsCodeTask() {
        this.setGroup("Integration Server");
        this.dependsOn(new Object[]{"startServerInstance"});
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        if (WorkerUtil.Companion.hasWorkers(project)) {
            this.dependsOn(new Object[]{"startWorkers"});
        }
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/digital/integration/server/deploy/tasks/provision/RunDevOpsAsCodeTask$Companion;", "", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

