/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.release.util;

import ai.digital.integration.server.common.domain.Server;
import ai.digital.integration.server.common.util.DockerComposeUtil;
import ai.digital.integration.server.common.util.FileUtil;
import ai.digital.integration.server.common.util.IntegrationServerUtil;
import ai.digital.integration.server.common.util.PropertyUtil;
import ai.digital.integration.server.common.util.WaitForBootUtil;
import ai.digital.integration.server.release.ReleaseIntegrationServerExtension;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lai/digital/integration/server/release/util/ReleaseServerUtil;", "", "()V", "Companion", "integration-server-gradle-plugin"})
public final class ReleaseServerUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0002J\b\u0010\b\u001a\u00020\u0004H\u0002J\u001f\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\b\u0010\u0010\u001a\u00020\u0004H\u0002J\u0018\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0004H\u0002J\u000e\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u0005\u001a\u00020\u0006J\u0018\u0010 \u001a\u00020\u001b2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010!\u001a\u0004\u0018\u00010\"\u00a8\u0006#"}, d2={"Lai/digital/integration/server/release/util/ReleaseServerUtil$Companion;", "", "()V", "composeUrl", "", "project", "Lorg/gradle/api/Project;", "path", "dockerServerRelativePath", "getDebugPort", "", "server", "Lai/digital/integration/server/common/domain/Server;", "(Lorg/gradle/api/Project;Lai/digital/integration/server/common/domain/Server;)Ljava/lang/Integer;", "getDockerImageVersion", "getDockerServiceName", "getHttpHost", "getHttpPort", "getRelativePathInIntegrationServerDist", "Ljava/nio/file/Path;", "relativePath", "getResolvedDockerFile", "getServer", "getServerVersion", "getServerWorkingDir", "getUrl", "grantPermissionsToIntegrationServerFolder", "", "isDockerBased", "", "isReleaseServerDefined", "isTls", "waitForBoot", "process", "Ljava/lang/Process;", "integration-server-gradle-plugin"})
    public static final class Companion {
        private final String getHttpHost() {
            return "localhost";
        }

        private final String getUrl(Project project) {
            Server server = this.getServer(project);
            String hostName = this.getHttpHost();
            return this.isTls(project) ? "https://" + hostName + ':' + server.getHttpPort() + server.getContextRoot() : "http://" + hostName + ':' + server.getHttpPort() + server.getContextRoot();
        }

        private final String composeUrl(Project project, String path) {
            String url = this.getUrl(project);
            String separator = "/";
            if (StringsKt.startsWith$default((String)path, (String)"/", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)url, (String)"/", (boolean)false, (int)2, null)) {
                separator = "";
                if (StringsKt.startsWith$default((String)path, (String)"/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)url, (String)"/", (boolean)false, (int)2, null)) {
                    url = StringsKt.removeSuffix((String)url, (CharSequence)"/");
                }
            }
            return url + separator + path;
        }

        public final boolean isTls(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            return this.getServer(project).getTls();
        }

        @NotNull
        public final Server getServer(@NotNull Project project) {
            Server server;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Object object = project.getExtensions().getByType(ReleaseIntegrationServerExtension.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"project.extensions.getBy\u2026verExtension::class.java)");
            ReleaseIntegrationServerExtension ext = (ReleaseIntegrationServerExtension)object;
            Server server2 = server = (Server)CollectionsKt.first((Iterable)((Iterable)ext.getServers()));
            Intrinsics.checkExpressionValueIsNotNull((Object)server2, (String)"server");
            server.setDebugPort(this.getDebugPort(project, server2));
            server.setHttpPort(this.getHttpPort(project, server));
            server.setVersion(this.getServerVersion(project, server));
            String string = server.getDockerImage();
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                server.setRuntimeDirectory(null);
            }
            if (!StringsKt.startsWith$default((String)server.getContextRoot(), (String)"/", (boolean)false, (int)2, null)) {
                server.setContextRoot("" + '/' + server + ".contextRoot");
            }
            return server;
        }

        @NotNull
        public final String getServerWorkingDir(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Path workDir = this.getRelativePathInIntegrationServerDist(project, "release");
            return ((Object)workDir.toAbsolutePath()).toString();
        }

        private final Path getRelativePathInIntegrationServerDist(Project project, String relativePath) {
            Path path = Paths.get(IntegrationServerUtil.Companion.getDist(project) + '/' + relativePath, new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"Paths.get(\"${Integration\u2026oject)}/${relativePath}\")");
            return path;
        }

        public final boolean isDockerBased(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            CharSequence charSequence = this.getServer(project).getDockerImage();
            boolean bl = false;
            boolean bl2 = false;
            return !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence));
        }

        private final String getServerVersion(Project project, Server server) {
            return project.hasProperty("xlReleaseVersion") ? String.valueOf(project.property("xlReleaseVersion")) : server.getVersion();
        }

        private final int getHttpPort(Project project, Server server) {
            int n;
            if (project.hasProperty("serverHttpPort")) {
                Integer n2 = Integer.valueOf(String.valueOf(project.property("serverHttpPort")));
                Intrinsics.checkExpressionValueIsNotNull((Object)n2, (String)"Integer.valueOf(project.\u2026verHttpPort\").toString())");
                n = n2;
            } else {
                n = server.getHttpPort();
            }
            return n;
        }

        private final Integer getDebugPort(Project project, Server server) {
            return PropertyUtil.Companion.resolveBooleanValue(project, "debug", true) ? PropertyUtil.Companion.resolveIntValue(project, "serverDebugPort", server.getDebugPort()) : null;
        }

        public final void grantPermissionsToIntegrationServerFolder(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            if (this.isDockerBased(project)) {
                String workDir = IntegrationServerUtil.Companion.getDist(project);
                Sequence $this$forEach$iv = (Sequence)FilesKt.walk$default((File)new File(workDir), null, (int)1, null);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    File it = (File)element$iv;
                    boolean bl = false;
                    FileUtil.Companion.grantRWPermissions(it);
                }
            }
        }

        public final boolean isReleaseServerDefined(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Object object = project.getExtensions().getByType(ReleaseIntegrationServerExtension.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"project.extensions.getBy\u2026verExtension::class.java)");
            ReleaseIntegrationServerExtension ext = (ReleaseIntegrationServerExtension)object;
            return ext.getServers().size() > 0;
        }

        public final void waitForBoot(@NotNull Project project, @Nullable Process process) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            String url = this.composeUrl(project, "/api/extension/metadata");
            Server server = this.getServer(project);
            WaitForBootUtil.Companion.byPort$default(WaitForBootUtil.Companion, project, "Release", url, process, server.getPingRetrySleepTime(), server.getPingTotalTries(), null, 64, null);
        }

        @NotNull
        public final String getDockerImageVersion(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Server server = this.getServer(project);
            return server.getDockerImage() + ':' + server.getVersion();
        }

        @NotNull
        public final String getDockerServiceName(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Server server = this.getServer(project);
            return "release-" + server.getVersion();
        }

        @NotNull
        public final Path getResolvedDockerFile(@NotNull Project project) {
            File serverTemplate;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Server server = this.getServer(project);
            Path resultComposeFilePath = DockerComposeUtil.Companion.getResolvedDockerPath(project, this.dockerServerRelativePath());
            File file = serverTemplate = resultComposeFilePath.toFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"serverTemplate");
            String configuredTemplate = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)FilesKt.readText((File)file, (Charset)Charsets.UTF_8), (String)"RELEASE_SERVER_HTTP_PORT", (String)String.valueOf(server.getHttpPort()), (boolean)false, (int)4, null), (String)"RELEASE_IMAGE_VERSION", (String)this.getDockerImageVersion(project), (boolean)false, (int)4, null), (String)"RELEASE_PLUGINS_TO_EXCLUDE", (String)CollectionsKt.joinToString$default((Iterable)server.getDefaultOfficialPluginsToExclude(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null), (boolean)false, (int)4, null), (String)"RELEASE_VERSION", (String)String.valueOf(server.getVersion()), (boolean)false, (int)4, null);
            FilesKt.writeText$default((File)serverTemplate, (String)configuredTemplate, null, (int)2, null);
            return resultComposeFilePath;
        }

        private final String dockerServerRelativePath() {
            return "release/server-docker-compose.yaml";
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

