/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.tasks.server.operator;

import ai.digital.integration.server.common.domain.Server;
import ai.digital.integration.server.common.util.DbUtil;
import ai.digital.integration.server.common.util.HTTPUtil;
import ai.digital.integration.server.common.util.YamlFileUtil;
import ai.digital.integration.server.deploy.internals.DeployServerUtil;
import com.fasterxml.jackson.core.TreeNode;
import java.io.File;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u0007\u001a\u00020\u0004H\u0007J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\f"}, d2={"Lai/digital/integration/server/deploy/tasks/server/operator/OperatorCentralConfigurationTask;", "Lorg/gradle/api/DefaultTask;", "()V", "createCentralConfigurationFiles", "", "server", "Lai/digital/integration/server/common/domain/Server;", "launch", "overlayRepositoryConfig", "serverDir", "", "Companion", "integration-server-gradle-plugin"})
public class OperatorCentralConfigurationTask
extends DefaultTask {
    @NotNull
    public static final String NAME = "operatorCentralConfiguration";
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final void overlayRepositoryConfig(String serverDir) {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        project.getLogger().lifecycle("Creating a custom deploy-repository.yaml");
        File deployRepositoryYaml = new File(serverDir + "/centralConfiguration/deploy-repository.yaml");
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        TreeNode treeNode = DbUtil.Companion.dbConfig(project2);
        if (treeNode != null) {
            TreeNode treeNode2 = treeNode;
            boolean bl = false;
            boolean bl2 = false;
            TreeNode config = treeNode2;
            boolean bl3 = false;
            YamlFileUtil.Companion.writeFileValue$default(YamlFileUtil.Companion, deployRepositoryYaml, config, false, 4, null);
        }
        String string = FilesKt.readText((File)deployRepositoryYaml, (Charset)Charsets.UTF_8);
        Project project3 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
        String configuredTemplate = StringsKt.replace$default((String)string, (String)"{{DB_PORT}}", (String)String.valueOf(DbUtil.Companion.getPort(project3)), (boolean)false, (int)4, null);
        FilesKt.writeText$default((File)deployRepositoryYaml, (String)configuredTemplate, null, (int)2, null);
    }

    private final void createCentralConfigurationFiles(Server server) {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        project.getLogger().lifecycle("Generating initial central configuration files for server " + server.getName());
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        String serverDir = DeployServerUtil.Companion.getServerWorkingDir(project2, server);
        this.overlayRepositoryConfig(serverDir);
        Project project3 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
        project3.getLogger().lifecycle("Creating custom deploy-server.yaml");
        YamlFileUtil.Companion.overlayFile$default(YamlFileUtil.Companion, new File(serverDir + "/centralConfiguration/deploy-server.yaml"), MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"deploy.server.port", (Object)HTTPUtil.Companion.findFreePort()), TuplesKt.to((Object)"deploy.server.hostname", (Object)"127.0.0.1")}), false, 4, null);
        Project project4 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project4, (String)"project");
        project4.getLogger().lifecycle("Creating custom deploy-task.yaml");
        YamlFileUtil.Companion.overlayFile$default(YamlFileUtil.Companion, new File(serverDir + "/centralConfiguration/deploy-task.yaml"), MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"deploy.task.in-process-worker", (Object)"true"), TuplesKt.to((Object)"deploy.task.planner.registries.timeout", (Object)"5 minutes"), TuplesKt.to((Object)"deploy.task.queue.name", (Object)"xld-tasks-queue"), TuplesKt.to((Object)"deploy.task.queue.archive-queue-name", (Object)"xld-archive-queue")}), false, 4, null);
    }

    @TaskAction
    public final void launch() {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        Iterable $this$forEach$iv = DeployServerUtil.Companion.getServers(project);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Server server = (Server)element$iv;
            boolean bl = false;
            if (!(server.numericVersion() >= 10.2)) continue;
            this.createCentralConfigurationFiles(server);
        }
    }

    public OperatorCentralConfigurationTask() {
        this.setGroup("Integration Server");
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/digital/integration/server/deploy/tasks/server/operator/OperatorCentralConfigurationTask$Companion;", "", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

