/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.internals;

import ai.digital.integration.server.common.cluster.DockerClusterHelper;
import ai.digital.integration.server.common.cluster.DockerClusterHelperCreator;
import ai.digital.integration.server.common.cluster.operator.OperatorHelper;
import ai.digital.integration.server.common.constant.ProductName;
import ai.digital.integration.server.common.domain.Server;
import ai.digital.integration.server.deploy.internals.DeployServerUtil;
import ai.digital.integration.server.deploy.internals.EntryPointUrlUtil$WhenMappings;
import ai.digital.integration.server.deploy.internals.cluster.DeployClusterUtil;
import ai.digital.integration.server.release.tasks.cluster.ReleaseClusterUtil;
import ai.digital.integration.server.release.util.ReleaseServerUtil;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\f2\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0011\u001a\u00020\f2\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0012\u001a\u00020\f2\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ \u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0016\u001a\u00020\f2\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0017\u001a\u00020\u000fH\u0002J\b\u0010\u0018\u001a\u00020\u000fH\u0002J\b\u0010\u0019\u001a\u00020\u000fH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Lai/digital/integration/server/deploy/internals/EntryPointUrlUtil;", "", "project", "Lorg/gradle/api/Project;", "productName", "Lai/digital/integration/server/common/constant/ProductName;", "(Lorg/gradle/api/Project;Lai/digital/integration/server/common/constant/ProductName;)V", "getProductName", "()Lai/digital/integration/server/common/constant/ProductName;", "getProject", "()Lorg/gradle/api/Project;", "composeUrl", "", "path", "auxiliaryServer", "", "getContextRoot", "getHttpHost", "getHttpPort", "getPropertyValue", "key", "clusterValue", "getUrl", "isClusterEnabled", "isOperatorProvider", "isTls", "integration-server-gradle-plugin"})
public final class EntryPointUrlUtil {
    @NotNull
    private final Project project;
    @NotNull
    private final ProductName productName;

    private final String getPropertyValue(String key, String clusterValue, boolean auxiliaryServer) {
        String string;
        if (this.isClusterEnabled() && !auxiliaryServer) {
            return clusterValue;
        }
        switch (EntryPointUrlUtil$WhenMappings.$EnumSwitchMapping$0[this.productName.ordinal()]) {
            case 1: {
                string = DeployServerUtil.Companion.readDeployitConfProperty(this.project, key);
                break;
            }
            case 2: {
                string = ReleaseServerUtil.Companion.readReleaseServerConfProperty(this.project, key);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @NotNull
    public final String getHttpPort(boolean auxiliaryServer) {
        if (this.isOperatorProvider() && !auxiliaryServer) {
            OperatorHelper operatorHelper = OperatorHelper.Companion.getOperatorHelper(this.project, this.productName);
            return operatorHelper.getPort();
        }
        if (auxiliaryServer) {
            OperatorHelper operatorHelper = OperatorHelper.Companion.getOperatorHelper(this.project, ProductName.DEPLOY);
            Server server = operatorHelper.getOperatorDeployServer(this.project);
            return String.valueOf(server.getHttpPort());
        }
        DockerClusterHelper dockerHelper = DockerClusterHelperCreator.Companion.create(this.project, this.productName);
        return this.getPropertyValue("http.port", dockerHelper.getClusterPublicPort(), auxiliaryServer);
    }

    public static /* synthetic */ String getHttpPort$default(EntryPointUrlUtil entryPointUrlUtil, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return entryPointUrlUtil.getHttpPort(bl);
    }

    @NotNull
    public final String getContextRoot(boolean auxiliaryServer) {
        if (this.isOperatorProvider() && !auxiliaryServer) {
            OperatorHelper operatorHelper = OperatorHelper.Companion.getOperatorHelper(this.project, this.productName);
            return operatorHelper.getContextRoot();
        }
        return this.getPropertyValue("http.context.root", "", auxiliaryServer);
    }

    public static /* synthetic */ String getContextRoot$default(EntryPointUrlUtil entryPointUrlUtil, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return entryPointUrlUtil.getContextRoot(bl);
    }

    @NotNull
    public final String getHttpHost(boolean auxiliaryServer) {
        if (this.isOperatorProvider() && !auxiliaryServer) {
            OperatorHelper operatorHelper = OperatorHelper.Companion.getOperatorHelper(this.project, this.productName);
            return operatorHelper.getFqdn();
        }
        return "localhost";
    }

    public static /* synthetic */ String getHttpHost$default(EntryPointUrlUtil entryPointUrlUtil, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return entryPointUrlUtil.getHttpHost(bl);
    }

    @NotNull
    public final String getUrl(boolean auxiliaryServer) {
        String protocol;
        String string = protocol = this.isTls() ? "https" : "http";
        if (this.isOperatorProvider() && !auxiliaryServer) {
            OperatorHelper operatorHelper = OperatorHelper.Companion.getOperatorHelper(this.project, this.productName);
            return protocol + "://" + operatorHelper.getFqdn();
        }
        String contextRoot = this.getContextRoot(auxiliaryServer);
        String host = this.getHttpHost(auxiliaryServer);
        String port = this.getHttpPort(auxiliaryServer);
        return protocol + "://" + host + ':' + port + contextRoot;
    }

    public static /* synthetic */ String getUrl$default(EntryPointUrlUtil entryPointUrlUtil, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return entryPointUrlUtil.getUrl(bl);
    }

    @NotNull
    public final String composeUrl(@NotNull String path, boolean auxiliaryServer) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        String url = this.getUrl(auxiliaryServer);
        String separator = "/";
        if (StringsKt.startsWith$default((String)path, (String)"/", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)url, (String)"/", (boolean)false, (int)2, null)) {
            separator = "";
            if (StringsKt.startsWith$default((String)path, (String)"/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)url, (String)"/", (boolean)false, (int)2, null)) {
                url = StringsKt.removeSuffix((String)url, (CharSequence)"/");
            }
        }
        return url + separator + path;
    }

    public static /* synthetic */ String composeUrl$default(EntryPointUrlUtil entryPointUrlUtil, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return entryPointUrlUtil.composeUrl(string, bl);
    }

    private final boolean isClusterEnabled() {
        boolean bl;
        switch (EntryPointUrlUtil$WhenMappings.$EnumSwitchMapping$1[this.productName.ordinal()]) {
            case 1: {
                bl = DeployServerUtil.Companion.isClusterEnabled(this.project);
                break;
            }
            case 2: {
                bl = ReleaseServerUtil.Companion.isClusterEnabled(this.project);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    private final boolean isOperatorProvider() {
        boolean bl;
        switch (EntryPointUrlUtil$WhenMappings.$EnumSwitchMapping$2[this.productName.ordinal()]) {
            case 1: {
                bl = DeployClusterUtil.Companion.isOperatorProvider(this.project);
                break;
            }
            case 2: {
                bl = ReleaseClusterUtil.Companion.isOperatorProvider(this.project);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    private final boolean isTls() {
        boolean bl;
        switch (EntryPointUrlUtil$WhenMappings.$EnumSwitchMapping$3[this.productName.ordinal()]) {
            case 1: {
                bl = DeployServerUtil.Companion.isTls(this.project);
                break;
            }
            case 2: {
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final ProductName getProductName() {
        return this.productName;
    }

    public EntryPointUrlUtil(@NotNull Project project, @NotNull ProductName productName) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)((Object)productName), (String)"productName");
        this.project = project;
        this.productName = productName;
    }
}

