/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.tasks.cluster.operator;

import ai.digital.integration.server.common.cluster.operator.OperatorHelper;
import ai.digital.integration.server.common.constant.OperatorProviderName;
import ai.digital.integration.server.common.constant.ProductName;
import ai.digital.integration.server.common.domain.InfrastructureInfo;
import ai.digital.integration.server.common.util.XlCliUtil;
import ai.digital.integration.server.deploy.internals.cluster.DeployClusterUtil;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0007J\u0018\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R$\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0014"}, d2={"Lai/digital/integration/server/deploy/tasks/cluster/operator/OperatorBasedUpgradeDeployClusterTask;", "Lorg/gradle/api/DefaultTask;", "()V", "repositoryName", "Lorg/gradle/api/provider/Property;", "", "kotlin.jvm.PlatformType", "getRepositoryName", "()Lorg/gradle/api/provider/Property;", "targetVersion", "getTargetVersion", "launch", "", "opUsingAnswersFile", "operatorHelper", "Lai/digital/integration/server/common/cluster/operator/OperatorHelper;", "answersFile", "Ljava/io/File;", "prepareAnswersFile", "Companion", "integration-server-gradle-plugin"})
public class OperatorBasedUpgradeDeployClusterTask
extends DefaultTask {
    @Input
    @NotNull
    private final Property<String> repositoryName;
    @Input
    @NotNull
    private final Property<String> targetVersion;
    @NotNull
    public static final String NAME = "operatorBasedUpgradeDeployCluster";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Property<String> getRepositoryName() {
        return this.repositoryName;
    }

    @NotNull
    public final Property<String> getTargetVersion() {
        return this.targetVersion;
    }

    @TaskAction
    public final void launch() {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        OperatorHelper operatorHelper = OperatorHelper.Companion.getOperatorHelper(project, ProductName.DEPLOY);
        File answersFile = this.prepareAnswersFile(operatorHelper);
        this.opUsingAnswersFile(operatorHelper, answersFile);
        operatorHelper.waitForDeployment();
        operatorHelper.waitForMasterPods();
        operatorHelper.waitForWorkerPods();
        operatorHelper.waitForBoot();
    }

    private final File prepareAnswersFile(OperatorHelper operatorHelper) {
        File answersFile = operatorHelper.getTemplate("operator/xl-upgrade/answers.yaml");
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        project.getLogger().lifecycle("Preparing answers file " + answersFile.getAbsolutePath());
        String operatorImage = operatorHelper.getOperatorImage();
        String crdName = operatorHelper.getKubectlHelper().getCrd();
        String crName = operatorHelper.getKubectlHelper().getCr(crdName);
        Map<OperatorProviderName, String> map2 = XlCliUtil.Companion.getXL_OP_MAPPING();
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        String k8sSetup = map2.get((Object)DeployClusterUtil.Companion.getOperatorProviderName(project2));
        InfrastructureInfo kubeContextInfo = operatorHelper.getCurrentContextInfo();
        String string = StringsKt.replace$default((String)StringsKt.replace$default((String)FilesKt.readText((File)answersFile, (Charset)Charsets.UTF_8), (String)"{{CRD_NAME}}", (String)crdName, (boolean)false, (int)4, null), (String)"{{CR_NAME}}", (String)crName, (boolean)false, (int)4, null);
        String string2 = kubeContextInfo.getApiServerURL();
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        String string3 = StringsKt.replace$default((String)string, (String)"{{K8S_API_SERVER_URL}}", (String)string2, (boolean)false, (int)4, null);
        String string4 = kubeContextInfo.getCaCert();
        if (string4 == null) {
            Intrinsics.throwNpe();
        }
        String string5 = StringsKt.replace$default((String)string3, (String)"{{K8S_CLIENT_CERT}}", (String)string4, (boolean)false, (int)4, null);
        String string6 = kubeContextInfo.getTlsPrivateKey();
        if (string6 == null) {
            Intrinsics.throwNpe();
        }
        String string7 = StringsKt.replace$default((String)string5, (String)"{{K8S_CLIENT_KEY}}", (String)string6, (boolean)false, (int)4, null);
        String string8 = k8sSetup;
        if (string8 == null) {
            Intrinsics.throwNpe();
        }
        String string9 = StringsKt.replace$default((String)StringsKt.replace$default((String)string7, (String)"{{K8S_SETUP}}", (String)string8, (boolean)false, (int)4, null), (String)"{{OPERATOR_IMAGE}}", (String)operatorImage, (boolean)false, (int)4, null);
        Object object = this.repositoryName.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"repositoryName.get()");
        String string10 = StringsKt.replace$default((String)string9, (String)"{{REPOSITORY_NAME}}", (String)((String)object), (boolean)false, (int)4, null);
        Object object2 = this.targetVersion.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"targetVersion.get()");
        String answersFileTemplate = StringsKt.replace$default((String)string10, (String)"{{IMAGE_TAG}}", (String)((String)object2), (boolean)false, (int)4, null);
        FilesKt.writeText$default((File)answersFile, (String)answersFileTemplate, null, (int)2, null);
        return answersFile;
    }

    private final void opUsingAnswersFile(OperatorHelper operatorHelper, File answersFile) {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        project.getLogger().lifecycle("Applying prepared answers file " + answersFile.getAbsolutePath());
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        Object object = operatorHelper.getProfile().getXlCliVersion().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"operatorHelper.getProfile().xlCliVersion.get()");
        XlCliUtil.Companion.xlOp(project2, answersFile, (String)object, new File(operatorHelper.getProviderHomeDir()));
    }

    public OperatorBasedUpgradeDeployClusterTask() {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        ObjectFactory objectFactory = project.getObjects();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectFactory, (String)"project.objects");
        ObjectFactory $this$property$iv = objectFactory;
        boolean $i$f$property = false;
        Property property = $this$property$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"property(T::class.java)");
        Property property2 = property.value((Object)"xebialabs");
        Intrinsics.checkExpressionValueIsNotNull((Object)property2, (String)"project.objects.property\u2026ing>().value(\"xebialabs\")");
        this.repositoryName = property2;
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        ObjectFactory objectFactory2 = project2.getObjects();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectFactory2, (String)"project.objects");
        $this$property$iv = objectFactory2;
        $i$f$property = false;
        Property property3 = $this$property$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property3, (String)"property(T::class.java)");
        this.targetVersion = property3;
        this.setGroup("Integration Server");
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/digital/integration/server/deploy/tasks/cluster/operator/OperatorBasedUpgradeDeployClusterTask$Companion;", "", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

