/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.internals.cluster.operator;

import ai.digital.integration.server.common.domain.InfrastructureInfo;
import ai.digital.integration.server.common.domain.providers.operator.OnPremiseProvider;
import ai.digital.integration.server.common.util.KubeCtlHelper;
import ai.digital.integration.server.common.util.ProcessUtil;
import ai.digital.integration.server.common.util.YamlFileUtil;
import ai.digital.integration.server.deploy.internals.cluster.operator.OnPremHelper;
import ai.digital.integration.server.deploy.internals.cluster.operator.OperatorHelper;
import java.io.File;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.provider.Property;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J<\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\u0011\u001a\u00020\bH\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\bH\u0016J\u0006\u0010\u0016\u001a\u00020\u0006J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0006\u0010\u0019\u001a\u00020\u0006J\u0010\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\u001b\u001a\u00020\u0006H\u0002J\u0010\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001fJ\b\u0010 \u001a\u00020\u0006H\u0002\u00a8\u0006!"}, d2={"Lai/digital/integration/server/deploy/internals/cluster/operator/OnPremHelper;", "Lai/digital/integration/server/deploy/internals/cluster/operator/OperatorHelper;", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "createCluster", "", "name", "", "clusterNodeCpus", "Lorg/gradle/api/provider/Property;", "", "clusterNodeMemory", "kubernetesVersion", "skipExisting", "", "deleteCluster", "getFqdn", "getMinikubeIp", "getProvider", "Lai/digital/integration/server/common/domain/providers/operator/OnPremiseProvider;", "getProviderHomeDir", "launchCluster", "onPremClusterName", "shouldSkipExisting", "shutdownCluster", "updateContext", "updateCrValues", "updateEtcHosts", "updateInfrastructure", "infraInfo", "Lai/digital/integration/server/common/domain/InfrastructureInfo;", "validateMinikubeCli", "integration-server-gradle-plugin"})
public class OnPremHelper
extends OperatorHelper {
    public final void launchCluster() {
        OnPremiseProvider onPremiseProvider = this.getProvider();
        Object object = onPremiseProvider.getName().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"onPremiseProvider.name.get()");
        String name = (String)object;
        Object object2 = onPremiseProvider.getSkipExisting().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"onPremiseProvider.skipExisting.get()");
        boolean skipExisting = (Boolean)object2;
        Object object3 = onPremiseProvider.getKubernetesVersion().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"onPremiseProvider.kubernetesVersion.get()");
        String kubernetesVersion = (String)object3;
        this.validateMinikubeCli();
        this.createCluster(name, onPremiseProvider.getClusterNodeCpus(), onPremiseProvider.getClusterNodeMemory(), kubernetesVersion, skipExisting);
        this.updateContext(name);
        InfrastructureInfo kubeContextInfo = KubeCtlHelper.getCurrentContextInfo$default(this.getKubectlHelper(), false, 1, null);
        this.updateOperatorDeployment();
        this.updateOperatorDeploymentCr();
        this.updateInfrastructure(kubeContextInfo);
        this.updateOperatorCrValues();
        this.updateCrValues();
        this.updateEtcHosts(name);
        this.applyYamlFiles();
        this.waitForDeployment();
        this.waitForMasterPods();
        this.waitForWorkerPods();
        this.createClusterMetadata();
        this.waitForBoot();
    }

    public final void shutdownCluster() {
        OnPremiseProvider onPremiseProvider = this.getProvider();
        Object object = onPremiseProvider.getName().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"onPremiseProvider.name.get()");
        String name = (String)object;
        this.undeployCluster();
        this.deleteCluster(name);
        this.getProject().getLogger().lifecycle("Current cluster context is being deleted");
        this.getKubectlHelper().deleteCurrentContext();
    }

    @Override
    @NotNull
    public String getProviderHomeDir() {
        return this.getOperatorHomeDir() + "/deploy-operator-onprem";
    }

    @Override
    @NotNull
    public OnPremiseProvider getProvider() {
        return this.getProfile().getOnPremise();
    }

    public final void updateInfrastructure(@NotNull InfrastructureInfo infraInfo) {
        Intrinsics.checkParameterIsNotNull((Object)infraInfo, (String)"infraInfo");
        File file = new File(this.getProviderHomeDir(), "digitalai-deploy/infrastructure.yaml");
        Pair[] pairArray = new Pair[4];
        String string = infraInfo.getApiServerURL();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        pairArray[0] = TuplesKt.to((Object)"spec[0].children[0].apiServerURL", (Object)string);
        String string2 = infraInfo.getCaCert();
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        pairArray[1] = TuplesKt.to((Object)"spec[0].children[0].caCert", (Object)string2);
        String string3 = infraInfo.getTlsCert();
        if (string3 == null) {
            Intrinsics.throwNpe();
        }
        pairArray[2] = TuplesKt.to((Object)"spec[0].children[0].tlsCert", (Object)string3);
        String string4 = infraInfo.getTlsPrivateKey();
        if (string4 == null) {
            Intrinsics.throwNpe();
        }
        pairArray[3] = TuplesKt.to((Object)"spec[0].children[0].tlsPrivateKey", (Object)string4);
        Map pairs = MapsKt.mutableMapOf((Pair[])pairArray);
        YamlFileUtil.Companion.overlayFile$default(YamlFileUtil.Companion, file, pairs, false, 4, null);
    }

    @Override
    @NotNull
    public String getFqdn() {
        return this.getHost() + ".digitalai-testing.com";
    }

    private final void validateMinikubeCli() {
        long l = 0L;
        boolean bl = false;
        boolean bl2 = false;
        String result = ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "minikube version", null, bl, bl2, l, 36, null);
        if (!StringsKt.contains$default((CharSequence)result, (CharSequence)"minikube version", (boolean)false, (int)2, null)) {
            throw (Throwable)new RuntimeException("No minikube-cli \"minikube\" in the path. Please verify your installation");
        }
    }

    private final boolean shouldSkipExisting(String name, boolean skipExisting) {
        boolean bl;
        String clusterName = this.onPremClusterName(name);
        if (skipExisting) {
            long l = 0L;
            boolean bl2 = false;
            boolean bl3 = false;
            String profileListResult = ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "minikube profile list | grep " + clusterName, null, bl2, bl3, l, 36, null);
            if (StringsKt.contains$default((CharSequence)profileListResult, (CharSequence)clusterName, (boolean)false, (int)2, null)) {
                long l2 = 0L;
                bl3 = false;
                boolean bl4 = false;
                String profileResult = ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "minikube profile", null, bl3, bl4, l2, 36, null);
                if (!StringsKt.contains$default((CharSequence)profileResult, (CharSequence)clusterName, (boolean)false, (int)2, null)) {
                    ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "minikube profile " + clusterName, null, false, false, 0L, 52, null);
                }
                bl = true;
            } else {
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private final void createCluster(String name, Property<Integer> clusterNodeCpus, Property<Integer> clusterNodeMemory, String kubernetesVersion, boolean skipExisting) {
        String clusterName = this.onPremClusterName(name);
        boolean shouldSkipExisting = this.shouldSkipExisting(name, skipExisting);
        if (shouldSkipExisting) {
            this.getProject().getLogger().lifecycle("Skipping creation of the existing minikube cluster: {}", new Object[]{clusterName});
        } else {
            this.getProject().getLogger().lifecycle("Create minikube cluster: {}", new Object[]{clusterName});
            String additions2 = (String)clusterNodeCpus.map((Transformer)createCluster.additions.1.INSTANCE).getOrElse((Object)"") + (String)clusterNodeMemory.map((Transformer)createCluster.additions.2.INSTANCE).getOrElse((Object)"");
            ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "minikube start --driver=virtualbox --kubernetes-version \"" + kubernetesVersion + "\" -p " + clusterName + ' ' + additions2, null, false, false, 0L, 60, null);
            ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "minikube addons enable ingress -p " + clusterName, null, false, false, 0L, 60, null);
            ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "minikube addons enable ingress-dns -p " + clusterName, null, false, false, 0L, 60, null);
        }
    }

    private final void updateContext(String name) {
        String clusterName = this.onPremClusterName(name);
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "minikube update-context -p " + clusterName, null, false, false, 0L, 44, null);
    }

    private final void deleteCluster(String name) {
        String clusterName = this.onPremClusterName(name);
        this.getProject().getLogger().lifecycle("Minikube cluster is being deleted {} ", new Object[]{clusterName});
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "minikube delete -p " + clusterName, null, false, false, 0L, 44, null);
    }

    private final void updateEtcHosts(String name) {
        File infoScriptPath = this.getTemplate("operator/on-perm/info_etc_hosts.sh");
        File scriptPath = this.getTemplate("operator/on-perm/update_etc_hosts.sh");
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "chmod 755 \"" + infoScriptPath.getAbsolutePath() + '\"', null, false, false, 0L, 60, null);
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "chmod 755 \"" + scriptPath.getAbsolutePath() + '\"', null, false, false, 0L, 60, null);
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), '\"' + infoScriptPath.getAbsolutePath() + '\"', null, false, false, 0L, 44, null);
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "sudo \"" + scriptPath.getAbsolutePath() + "\" " + this.getMinikubeIp(name) + " \"" + this.getFqdn() + '\"', null, false, false, 0L, 44, null);
    }

    private final String getMinikubeIp(String name) {
        String string;
        String clusterName = this.onPremClusterName(name);
        try {
            String ip = ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "minikube -p " + clusterName + " ip", null, false, false, 0L, 52, null);
            this.getProject().getLogger().lifecycle("Get cluster IP for {}: {}", new Object[]{clusterName, ip});
        }
        catch (RuntimeException e) {
            string = null;
        }
        return string;
    }

    private final String onPremClusterName(String name) {
        return name;
    }

    private final void updateCrValues() {
        File file = new File(this.getProviderHomeDir(), "digitalai-deploy/kubernetes/daideploy_cr.yaml");
        Map pairs = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"spec.ingress.hosts", (Object)CollectionsKt.listOf((Object)this.getFqdn())), TuplesKt.to((Object)"spec.nginx-ingress-controller.defaultBackend.podSecurityContext", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"fsGroup", (Object)1001))), TuplesKt.to((Object)"spec.nginx-ingress-controller.podSecurityContext", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"fsGroup", (Object)1001)))});
        YamlFileUtil.Companion.overlayFile(file, pairs, false);
    }

    public OnPremHelper(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        super(project);
    }
}

