/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.cluster.helm;

import ai.digital.integration.server.common.cluster.helm.HelmHelper;
import ai.digital.integration.server.common.cluster.setup.GcpGkeHelper;
import ai.digital.integration.server.common.constant.ProductName;
import ai.digital.integration.server.common.domain.providers.GcpGkeProvider;
import ai.digital.integration.server.common.util.YamlFileUtil;
import java.io.File;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u000eJ\u0006\u0010\u0010\u001a\u00020\u000eJ\u0006\u0010\u0011\u001a\u00020\u000eJ\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lai/digital/integration/server/common/cluster/helm/GcpGkeHelmHelper;", "Lai/digital/integration/server/common/cluster/helm/HelmHelper;", "project", "Lorg/gradle/api/Project;", "productName", "Lai/digital/integration/server/common/constant/ProductName;", "(Lorg/gradle/api/Project;Lai/digital/integration/server/common/constant/ProductName;)V", "gcpGkeHelper", "Lai/digital/integration/server/common/cluster/setup/GcpGkeHelper;", "getFqdn", "", "getProvider", "Lai/digital/integration/server/common/domain/providers/GcpGkeProvider;", "helmInstallCluster", "", "launchCluster", "setupHelmValues", "shutdownCluster", "updateCustomHelmValues", "valuesFile", "Ljava/io/File;", "integration-server-gradle-plugin"})
public class GcpGkeHelmHelper
extends HelmHelper {
    private final GcpGkeHelper gcpGkeHelper;

    public final void launchCluster() {
        this.gcpGkeHelper.launchCluster();
    }

    public final void setupHelmValues() {
        this.copyValuesYamlFile();
        this.updateHelmValuesYaml();
        this.updateHelmDependency();
    }

    public final void helmInstallCluster() {
        this.installCluster();
        Object object = this.getProfile().getIngressType().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getProfile().ingressType.get()");
        String string = (String)object;
        Object object2 = this.getProfile().getDeploymentTimeoutSeconds().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"getProfile().deploymentTimeoutSeconds.get()");
        this.waitForDeployment(string, ((Number)object2).intValue(), true);
        Object object3 = this.getProfile().getDeploymentTimeoutSeconds().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"getProfile().deploymentTimeoutSeconds.get()");
        this.waitForMasterPods(((Number)object3).intValue());
        Object object4 = this.getProfile().getDeploymentTimeoutSeconds().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"getProfile().deploymentTimeoutSeconds.get()");
        this.waitForWorkerPods(((Number)object4).intValue());
        String ip = this.getKubectlHelper().getServiceExternalIp("service/" + this.getCrName() + "-nginx-ingress-controller");
        GcpGkeHelper.applyDnsOpenApi$default(this.gcpGkeHelper, ip, this.getFqdn(), this.getHost(), null, 8, null);
        this.createClusterMetadata();
        this.waitForBoot(this.getContextRoot(), this.getFqdn());
    }

    public final void shutdownCluster() {
        GcpGkeProvider gcpGkeProvider = this.getProvider();
        Object object = gcpGkeProvider.getProjectName().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"gcpGkeProvider.projectName.get()");
        String projectName = (String)object;
        Object object2 = gcpGkeProvider.getName().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"gcpGkeProvider.name.get()");
        String name = (String)object2;
        Object object3 = gcpGkeProvider.getRegionZone().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"gcpGkeProvider.regionZone.get()");
        String regionZone = (String)object3;
        Object object4 = gcpGkeProvider.getAccountName().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"gcpGkeProvider.accountName.get()");
        String accountName = (String)object4;
        boolean existsCluster = this.gcpGkeHelper.existsCluster(accountName, projectName, name, regionZone);
        if (existsCluster) {
            this.helmCleanUpCluster();
            this.getKubectlHelper().deleteAllPVCs();
        }
        this.gcpGkeHelper.destroyClusterOnShutdown(existsCluster, accountName, projectName, name, regionZone, this.getFqdn());
    }

    @Override
    @NotNull
    public GcpGkeProvider getProvider() {
        return this.getProfile().getGcpGke();
    }

    @Override
    public void updateCustomHelmValues(@NotNull File valuesFile) {
        Intrinsics.checkParameterIsNotNull((Object)valuesFile, (String)"valuesFile");
        Map pairs = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"ingress.hosts", (Object)new String[]{this.getFqdn()})});
        YamlFileUtil.Companion.overlayFile$default(YamlFileUtil.Companion, valuesFile, pairs, null, false, 4, null);
    }

    @Override
    @NotNull
    public String getFqdn() {
        return this.gcpGkeHelper.getFqdn();
    }

    public GcpGkeHelmHelper(@NotNull Project project, @NotNull ProductName productName) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)((Object)productName), (String)"productName");
        super(project, productName);
        this.gcpGkeHelper = new GcpGkeHelper(project, productName, this.getProfile());
    }
}

