/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.util;

import ai.digital.integration.server.common.util.HTTPUtil;
import ai.digital.integration.server.common.util.WaitForBootUtil;
import groovyx.net.http.HTTPBuilder;
import java.io.File;
import java.time.LocalDateTime;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lai/digital/integration/server/common/util/WaitForBootUtil;", "", "()V", "Companion", "integration-server-gradle-plugin"})
public final class WaitForBootUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\fJD\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00102\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\fJR\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00102\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\f2\u0014\b\u0002\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u0017J2\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00102\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\fJ4\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u001c"}, d2={"Lai/digital/integration/server/common/util/WaitForBootUtil$Companion;", "", "()V", "byFile", "", "project", "Lorg/gradle/api/Project;", "process", "Ljava/lang/Process;", "file", "Ljava/io/File;", "pingRetrySleepTime", "", "pingTotalTries", "byLog", "name", "", "logFile", "containsLine", "byPort", "Ljava/time/LocalDateTime;", "url", "callback", "Lkotlin/Function1;", "waitForNext", "triesLeft", "success", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        public final void byPort(@NotNull Project project, @NotNull String name, @NotNull String url, int pingRetrySleepTime, int pingTotalTries) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            ai.digital.integration.server.common.util.WaitForBootUtil$Companion.byPort$default(this, project, name, url, null, pingRetrySleepTime, pingTotalTries, null, 64, null);
        }

        public static /* synthetic */ void byPort$default(Companion companion, Project project, String string, String string2, int n, int n2, int n3, Object object) {
            if ((n3 & 8) != 0) {
                n = 10;
            }
            if ((n3 & 0x10) != 0) {
                n2 = 60;
            }
            companion.byPort(project, string, string2, n, n2);
        }

        private final int waitForNext(Project project, Process process, int triesLeft, boolean success, int pingRetrySleepTime) {
            if (!success) {
                project.getLogger().lifecycle("Retrying after " + pingRetrySleepTime + " second(s). (" + triesLeft + ')');
                if (process != null) {
                    if (process.waitFor(pingRetrySleepTime, TimeUnit.SECONDS)) {
                        return -1;
                    }
                } else {
                    TimeUnit.SECONDS.sleep(pingRetrySleepTime);
                }
            }
            return triesLeft - 1;
        }

        static /* synthetic */ int waitForNext$default(Companion companion, Project project, Process process, int n, boolean bl, int n2, int n3, Object object) {
            if ((n3 & 0x10) != 0) {
                n2 = 10;
            }
            return companion.waitForNext(project, process, n, bl, n2);
        }

        public final void byFile(@NotNull Project project, @Nullable Process process, @NotNull File file, int pingRetrySleepTime, int pingTotalTries) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            project.getLogger().lifecycle("Waiting for " + file + " to be created.");
            int triesLeft = pingTotalTries;
            boolean success = false;
            while (triesLeft > 0 && !success) {
                if (file.exists()) {
                    success = true;
                }
                triesLeft = this.waitForNext(project, process, triesLeft, success, pingRetrySleepTime);
            }
            if (!success) {
                throw (Throwable)new GradleException(file + " has failed to be created.");
            }
        }

        public static /* synthetic */ void byFile$default(Companion companion, Project project, Process process, File file, int n, int n2, int n3, Object object) {
            if ((n3 & 8) != 0) {
                n = 10;
            }
            if ((n3 & 0x10) != 0) {
                n2 = 60;
            }
            companion.byFile(project, process, file, n, n2);
        }

        @NotNull
        public final LocalDateTime byPort(@NotNull Project project, @NotNull String name, @NotNull String url, @Nullable Process process, int pingRetrySleepTime, int pingTotalTries, @NotNull Function1<? super LocalDateTime, LocalDateTime> callback) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            project.getLogger().lifecycle("Waiting for " + name + " to start on URL: " + url + '.');
            int triesLeft = pingTotalTries;
            boolean success = false;
            LocalDateTime lastTry = LocalDateTime.now().minusDays(1L);
            while (triesLeft > 0 && !success) {
                try {
                    HTTPBuilder http = HTTPUtil.Companion.buildRequest(url);
                    boolean bl = false;
                    http.get((Map)new LinkedHashMap());
                    success = true;
                }
                catch (Exception ignored) {
                    LocalDateTime localDateTime = lastTry;
                    Intrinsics.checkExpressionValueIsNotNull((Object)localDateTime, (String)"lastTry");
                    lastTry = (LocalDateTime)callback.invoke((Object)localDateTime);
                }
                triesLeft = this.waitForNext(project, process, triesLeft, success, pingRetrySleepTime);
            }
            if (!success) {
                throw (Throwable)new GradleException(name + " failed to start.");
            }
            LocalDateTime localDateTime = lastTry;
            Intrinsics.checkExpressionValueIsNotNull((Object)localDateTime, (String)"lastTry");
            return localDateTime;
        }

        public static /* synthetic */ LocalDateTime byPort$default(Companion companion, Project project, String string, String string2, Process process, int n, int n2, Function1 function1, int n3, Object object) {
            if ((n3 & 0x10) != 0) {
                n = 10;
            }
            if ((n3 & 0x20) != 0) {
                n2 = 60;
            }
            if ((n3 & 0x40) != 0) {
                function1 = byPort.1.INSTANCE;
            }
            return companion.byPort(project, string, string2, process, n, n2, (Function1<? super LocalDateTime, LocalDateTime>)function1);
        }

        /*
         * WARNING - void declaration
         */
        public final void byLog(@NotNull Project project, @NotNull String name, @NotNull File logFile, @NotNull String containsLine, @Nullable Process process, int pingRetrySleepTime, int pingTotalTries) {
            void success;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)logFile, (String)"logFile");
            Intrinsics.checkParameterIsNotNull((Object)containsLine, (String)"containsLine");
            project.getLogger().lifecycle("Waiting for " + name + " to start with log: '" + containsLine + "'.");
            int triesLeft = pingTotalTries;
            Ref.BooleanRef booleanRef = new Ref.BooleanRef();
            booleanRef.element = false;
            while (triesLeft > 0 && !success.element) {
                try {
                    FilesKt.forEachLine$default((File)logFile, null, (Function1)((Function1)new Function1<String, Unit>(containsLine, project, name, (Ref.BooleanRef)success){
                        final /* synthetic */ String $containsLine;
                        final /* synthetic */ Project $project;
                        final /* synthetic */ String $name;
                        final /* synthetic */ Ref.BooleanRef $success;

                        public final void invoke(@NotNull String line) {
                            Intrinsics.checkParameterIsNotNull((Object)line, (String)"line");
                            if (StringsKt.contains$default((CharSequence)line, (CharSequence)this.$containsLine, (boolean)false, (int)2, null)) {
                                this.$project.getLogger().lifecycle(this.$name + " successfully started.");
                                this.$success.element = true;
                            }
                        }
                        {
                            this.$containsLine = string;
                            this.$project = project;
                            this.$name = string2;
                            this.$success = booleanRef;
                            super(1);
                        }
                    }), (int)1, null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                triesLeft = this.waitForNext(project, process, triesLeft, success.element, pingRetrySleepTime);
            }
            if (!success.element) {
                throw (Throwable)new GradleException(name + " failed to start.");
            }
        }

        public static /* synthetic */ void byLog$default(Companion companion, Project project, String string, File file, String string2, Process process, int n, int n2, int n3, Object object) {
            if ((n3 & 0x20) != 0) {
                n = 10;
            }
            if ((n3 & 0x40) != 0) {
                n2 = 60;
            }
            companion.byLog(project, string, file, string2, process, n, n2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

