/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.tasks.satellite;

import ai.digital.integration.server.common.domain.Server;
import ai.digital.integration.server.common.util.ProcessUtil;
import ai.digital.integration.server.common.util.WaitForBootUtil;
import ai.digital.integration.server.deploy.domain.Satellite;
import ai.digital.integration.server.deploy.internals.DeployServerUtil;
import ai.digital.integration.server.deploy.internals.EnvironmentUtil;
import ai.digital.integration.server.deploy.internals.SatelliteUtil;
import java.io.File;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00052\u00020\u0001:\u0001\u0005B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0006"}, d2={"Lai/digital/integration/server/deploy/tasks/satellite/StartSatelliteTask;", "Lorg/gradle/api/DefaultTask;", "()V", "launch", "", "Companion", "integration-server-gradle-plugin"})
public class StartSatelliteTask
extends DefaultTask {
    @NotNull
    public static final String NAME = "startSatellite";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @TaskAction
    public final void launch() {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        Iterable $this$forEach$iv = SatelliteUtil.Companion.getSatellites(project);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File file;
            Satellite satellite = (Satellite)element$iv;
            boolean bl = false;
            Project project2 = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
            File binDir = SatelliteUtil.Companion.getBinDir(project2, satellite);
            Project project3 = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
            project3.getLogger().lifecycle("Launching Satellite '" + satellite.getName() + " from " + binDir + "'.");
            Project project4 = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project4, (String)"project");
            Map<String, String> environment = EnvironmentUtil.Companion.getEnv(project4, "JDK_JAVA_OPTIONS", satellite.getDebugSuspend(), satellite.getDebugPort(), "xl-satellite.log");
            Project project5 = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project5, (String)"project");
            project5.getLogger().info("Starting worker with environment: " + environment);
            Pair[] pairArray = new Pair[5];
            pairArray[0] = TuplesKt.to((Object)"command", (Object)"run");
            pairArray[1] = TuplesKt.to((Object)"environment", environment);
            pairArray[2] = TuplesKt.to((Object)"workDir", (Object)binDir);
            CharSequence charSequence = satellite.getStdoutFileName();
            boolean bl2 = false;
            boolean bl3 = false;
            pairArray[3] = TuplesKt.to((Object)"discardIO", (Object)(charSequence == null || charSequence.length() == 0 ? 1 : 0));
            charSequence = satellite.getStdoutFileName();
            bl2 = false;
            bl3 = false;
            if (!(charSequence == null || charSequence.length() == 0)) {
                StringBuilder stringBuilder = new StringBuilder();
                Project project6 = this.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project6, (String)"project");
                file = new File(stringBuilder.append(SatelliteUtil.Companion.getSatelliteLogDir(project6, satellite)).append('/').append(satellite.getStdoutFileName()).toString());
            } else {
                file = null;
            }
            pairArray[4] = TuplesKt.to((Object)"redirectTo", (Object)file);
            Process process = ProcessUtil.Companion.exec(MapsKt.mapOf((Pair[])pairArray));
            Project project7 = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project7, (String)"project");
            project7.getLogger().lifecycle("Satellite '" + satellite.getName() + "' successfully started on PID [" + process.pid() + "] with command [" + process.info().commandLine().orElse("") + "].");
            Project project8 = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project8, (String)"project");
            Server server = DeployServerUtil.Companion.getServer(project8);
            Project project9 = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project9, (String)"project");
            String string = "Satellite " + satellite.getName();
            Project project10 = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project10, (String)"project");
            WaitForBootUtil.Companion.byLog(project9, string, SatelliteUtil.Companion.getSatelliteLog(project10, satellite), "XL Satellite has started", process, server.getPingRetrySleepTime(), server.getPingTotalTries());
        }
    }

    public StartSatelliteTask() {
        this.setGroup("Integration Server");
        this.dependsOn(new Object[]{"downloadAndExtractSatelliteServer"});
        this.dependsOn(new Object[]{"prepareSatellites"});
        this.dependsOn(new Object[]{"satelliteOverlays"});
        this.dependsOn(new Object[]{"satelliteSyncPlugins"});
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        if (DeployServerUtil.Companion.isTls(project)) {
            this.dependsOn(new Object[]{"tlsApplicationConfigurationOverride"});
        }
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/digital/integration/server/deploy/tasks/satellite/StartSatelliteTask$Companion;", "", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

