/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.release.tasks;

import ai.digital.integration.server.common.constant.ProductName;
import ai.digital.integration.server.common.domain.Server;
import ai.digital.integration.server.common.util.DockerComposeUtil;
import ai.digital.integration.server.release.util.ReleaseServerUtil;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.logging.Logger;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\b"}, d2={"Lai/digital/integration/server/release/tasks/DockerBasedStopReleaseTask;", "Lorg/gradle/api/DefaultTask;", "()V", "getDockerComposeFile", "Ljava/io/File;", "run", "", "Companion", "integration-server-gradle-plugin"})
public class DockerBasedStopReleaseTask
extends DefaultTask {
    @NotNull
    public static final String NAME = "dockerBasedStopRelease";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @InputFiles
    @NotNull
    public final File getDockerComposeFile() {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        File file = ReleaseServerUtil.Companion.getResolvedDockerFile(project).toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"ReleaseServerUtil.getRes\u2026kerFile(project).toFile()");
        return file;
    }

    @TaskAction
    public final void run() {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        Logger logger = project.getLogger();
        StringBuilder stringBuilder = new StringBuilder().append("Stopping Release Server from a docker image ");
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        logger.lifecycle(stringBuilder.append(ReleaseServerUtil.Companion.getDockerImageVersion(project2)).toString());
        Project project3 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
        Server server = ReleaseServerUtil.Companion.getServer(project3);
        Project project4 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project4, (String)"project");
        DockerComposeUtil.Companion.allowToCleanMountedFiles(project4, ProductName.RELEASE, server, this.getDockerComposeFile());
        this.getProject().exec((Action)new Action<ExecSpec>(this){
            final /* synthetic */ DockerBasedStopReleaseTask this$0;

            public final void execute(@NotNull ExecSpec $this$exec) {
                Intrinsics.checkParameterIsNotNull((Object)$this$exec, (String)"$receiver");
                $this$exec.setExecutable("docker-compose");
                $this$exec.setArgs((List)CollectionsKt.arrayListOf((Object[])new String[]{"-f", this.this$0.getDockerComposeFile().getPath(), "down", "-v"}));
            }
            {
                this.this$0 = dockerBasedStopReleaseTask;
            }
        });
    }

    public DockerBasedStopReleaseTask() {
        this.setGroup("Integration Server");
        this.onlyIf((Spec)new Spec<Task>(){

            public final boolean isSatisfiedBy(Task it) {
                Project project = this.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                return ReleaseServerUtil.Companion.isDockerBased(project);
            }
        });
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/digital/integration/server/release/tasks/DockerBasedStopReleaseTask$Companion;", "", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

