/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.cluster;

import ai.digital.integration.server.common.cluster.Helper;
import ai.digital.integration.server.common.cluster.Helper$WhenMappings;
import ai.digital.integration.server.common.constant.ProductName;
import ai.digital.integration.server.common.domain.providers.Provider;
import ai.digital.integration.server.common.util.FileUtil;
import ai.digital.integration.server.common.util.KubeCtlHelper;
import ai.digital.integration.server.common.util.ProcessUtil;
import ai.digital.integration.server.deploy.internals.cluster.DeployClusterUtil;
import ai.digital.integration.server.release.tasks.cluster.ReleaseClusterUtil;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ\b\u0010\u000e\u001a\u00020\fH\u0016J\b\u0010\u000f\u001a\u00020\fH\u0016J\b\u0010\u0010\u001a\u00020\fH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0006\u0010\u0013\u001a\u00020\fJ\b\u0010\u0014\u001a\u00020\fH\u0016J\u0006\u0010\u0015\u001a\u00020\fJ\u0006\u0010\u0016\u001a\u00020\fJ\b\u0010\u0017\u001a\u00020\u0018H&J\u0006\u0010\u0019\u001a\u00020\fJ\b\u0010\u001a\u001a\u00020\fH\u0016J\u001a\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\f2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001f"}, d2={"Lai/digital/integration/server/common/cluster/Helper;", "", "project", "Lorg/gradle/api/Project;", "productName", "Lai/digital/integration/server/common/constant/ProductName;", "(Lorg/gradle/api/Project;Lai/digital/integration/server/common/constant/ProductName;)V", "getProductName", "()Lai/digital/integration/server/common/constant/ProductName;", "getProject", "()Lorg/gradle/api/Project;", "exec", "", "command", "getDbStorageClass", "getFqdn", "getHost", "getKubectlHelper", "Lai/digital/integration/server/common/util/KubeCtlHelper;", "getName", "getPort", "getPrefixName", "getProfileName", "getProvider", "Lai/digital/integration/server/common/domain/providers/Provider;", "getProviderWorkDir", "getStorageClass", "getTemplate", "Ljava/io/File;", "relativePath", "targetFilename", "integration-server-gradle-plugin"})
public abstract class Helper {
    @NotNull
    private final Project project;
    @NotNull
    private final ProductName productName;

    @NotNull
    public final String getProfileName() {
        String string;
        switch (Helper$WhenMappings.$EnumSwitchMapping$0[this.productName.ordinal()]) {
            case 1: {
                string = DeployClusterUtil.Companion.getProfile(this.project);
                break;
            }
            case 2: {
                string = ReleaseClusterUtil.Companion.getProfile(this.project);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @NotNull
    public abstract Provider getProvider();

    @NotNull
    public final String getProviderWorkDir() {
        String path = ((Object)this.project.getBuildDir().toPath().resolve((String)this.getProvider().getName().get() + "-work").toAbsolutePath()).toString();
        new File(path).mkdirs();
        return path;
    }

    @NotNull
    public String getStorageClass() {
        Object object = this.getProvider().getStorageClass().getOrElse((Object)"standard");
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getProvider().storageClass.getOrElse(\"standard\")");
        return (String)object;
    }

    @NotNull
    public String getDbStorageClass() {
        return this.getStorageClass();
    }

    @NotNull
    public String getFqdn() {
        Object object = this.getProvider().getHost().getOrElse(this.getProvider().getName().get());
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getProvider().host.getOr\u2026getProvider().name.get())");
        return (String)object;
    }

    @NotNull
    public String getHost() {
        Object object = this.getProvider().getHost().getOrElse(this.getProvider().getName().get());
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getProvider().host.getOr\u2026getProvider().name.get())");
        return (String)object;
    }

    @NotNull
    public String getPort() {
        return "80";
    }

    @NotNull
    public KubeCtlHelper getKubectlHelper() {
        return new KubeCtlHelper(this.project, null, false, 4, null);
    }

    @NotNull
    public final String getName() {
        String string = this.productName.toString();
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        return string3;
    }

    @NotNull
    public final String getPrefixName() {
        String string;
        switch (Helper$WhenMappings.$EnumSwitchMapping$1[this.productName.ordinal()]) {
            case 1: {
                string = "xld";
                break;
            }
            case 2: {
                string = "xlr";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @NotNull
    public final File getTemplate(@NotNull String relativePath, @Nullable String targetFilename) {
        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
        File file = new File(relativePath);
        InputStream fileStream2 = ((Object)((Object)getTemplate.fileStream.1.INSTANCE)).getClass().getClassLoader().getResourceAsStream(relativePath);
        String string = this.getProviderWorkDir();
        String[] stringArray = new String[1];
        String string2 = targetFilename;
        if (string2 == null) {
            string2 = file.getName();
        }
        stringArray[0] = string2;
        Path resultComposeFilePath = Paths.get(string, stringArray);
        InputStream inputStream = fileStream2;
        if (inputStream != null) {
            InputStream inputStream2 = inputStream;
            boolean bl = false;
            boolean bl2 = false;
            InputStream it = inputStream2;
            boolean bl3 = false;
            Path path = resultComposeFilePath;
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"resultComposeFilePath");
            FileUtil.Companion.copyFile(it, path);
        }
        File file2 = resultComposeFilePath.toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"resultComposeFilePath.toFile()");
        return file2;
    }

    public static /* synthetic */ File getTemplate$default(Helper helper, String string, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getTemplate");
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        return helper.getTemplate(string, string2);
    }

    @NotNull
    public final String exec(@NotNull String command) {
        Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
        return ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, command, null, false, false, 0L, 30, null);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final ProductName getProductName() {
        return this.productName;
    }

    public Helper(@NotNull Project project, @NotNull ProductName productName) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)((Object)productName), (String)"productName");
        this.project = project;
        this.productName = productName;
    }
}

