/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.tasks.kube.scanning;

import ai.digital.integration.server.common.util.KubeScanningUtil;
import ai.digital.integration.server.common.util.ProcessUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0016\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u0007\u001a\u00020\u0004H\u0007\u00a8\u0006\t"}, d2={"Lai/digital/integration/server/deploy/tasks/kube/scanning/CheckingOutKubeBenchTask;", "Lorg/gradle/api/DefaultTask;", "()V", "cloneRepository", "", "tagVersion", "", "launch", "Companion", "integration-server-gradle-plugin"})
public class CheckingOutKubeBenchTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "checkingOutKubeBench";

    @TaskAction
    public final void launch() {
        this.getProject().getLogger().lifecycle("Checking out kube-bench repo");
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        String tagVersion = KubeScanningUtil.Companion.getKubeScanner(project).getKubeBenchTagVersion();
        this.cloneRepository(tagVersion);
    }

    private final void cloneRepository(String tagVersion) {
        Object tag = "";
        if (!Intrinsics.areEqual((Object)tagVersion, (Object)"latest")) {
            tag = "--branch " + tagVersion + " ";
        }
        Project project = this.getProject();
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        String string = "git clone " + (String)tag + "https://github.com/aquasecurity/kube-bench.git \"" + KubeScanningUtil.Companion.getKubeBenchDir(project2) + "\"";
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, project, string, null, KubeScanningUtil.Companion.getKubeScanner(project3).getLogOutput(), false, 0L, 52, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/digital/integration/server/deploy/tasks/kube/scanning/CheckingOutKubeBenchTask$Companion;", "", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

