/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.util;

import ai.digital.integration.server.common.domain.KubeScanner;
import ai.digital.integration.server.common.util.KubeCtlHelper;
import ai.digital.integration.server.common.util.ProcessUtil;
import ai.digital.integration.server.deploy.internals.DeployExtensionUtil;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.sf.json.JSONObject;
import net.sf.json.util.JSONTokener;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lai/digital/integration/server/common/util/KubeScanningUtil;", "", "()V", "Companion", "integration-server-gradle-plugin"})
public final class KubeScanningUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int DEFAULT_RETRY_SLEEP_TIME = 10;
    private static final int DEFAULT_RETRY_TRIES = 3;

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tJ\"\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000f2\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u000fJ\u000e\u0010\u0011\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\tH\u0002J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u0019\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lai/digital/integration/server/common/util/KubeScanningUtil$Companion;", "", "()V", "DEFAULT_RETRY_SLEEP_TIME", "", "DEFAULT_RETRY_TRIES", "buildKubeBench", "", "project", "Lorg/gradle/api/Project;", "generateReport", "fileName", "", "getAWSAccountId", "getCommand", "", "existingCommand", "getKubeBenchDir", "getKubeScanner", "Lai/digital/integration/server/common/domain/KubeScanner;", "getKubeScanningDir", "getKubeScanningReportDir", "Ljava/nio/file/Path;", "getKubectlHelper", "Lai/digital/integration/server/common/util/KubeCtlHelper;", "getRegion", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        private final String getKubeScanningDir(Project project) {
            return project.getBuildDir().toPath().toAbsolutePath() + "/kube-scanning";
        }

        @NotNull
        public final String getKubeBenchDir(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return ((Object)Paths.get(this.getKubeScanningDir(project) + "/kube-bench", new String[0]).toAbsolutePath()).toString();
        }

        public final void generateReport(@NotNull Project project, @NotNull String fileName) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, "mkdir \"" + this.getKubeScanningReportDir(project).toAbsolutePath() + "\"", null, false, false, 0L, 30, null);
            ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, "cd \"" + this.getKubeScanningReportDir(project).toAbsolutePath() + "\"", null, false, false, 0L, 30, null);
            String kubeBenchPod = ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, project, "kubectl get po | awk '/kube-bench/{print $1}'", null, this.getKubeScanner(project).getLogOutput(), false, 0L, 52, null);
            String status = null;
            int count = 3;
            do {
                status = ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, "kubectl get pods " + kubeBenchPod + " -o 'jsonpath={..status.containerStatuses[0].state.terminated.reason}'", null, false, false, 0L, 30, null);
                TimeUnit.SECONDS.sleep(10L);
            } while (!Intrinsics.areEqual((Object)status, (Object)"Completed") && count-- > 0);
            Object[] objectArray = new String[]{"logs", "pod/" + kubeBenchPod};
            String testReport = ProcessUtil.Companion.execute(project, "kubectl", CollectionsKt.listOf((Object[])objectArray), true);
            FilesKt.writeText$default((File)new File(this.getKubeScanningReportDir(project).toAbsolutePath() + "/" + fileName), (String)testReport, null, (int)2, null);
        }

        private final Path getKubeScanningReportDir(Project project) {
            Path path = Paths.get(this.getKubeScanningDir(project) + "/report", new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(\"${getKubeScanningDir(project)}/report\")");
            return path;
        }

        @NotNull
        public final String getAWSAccountId(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            String identityDetail = ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, "aws sts get-caller-identity", null, false, false, 0L, 30, null);
            Object object = new JSONTokener(identityDetail).nextValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type net.sf.json.JSONObject");
            JSONObject identity = (JSONObject)object;
            return identity.get("Account") + ".dkr.ecr." + this.getRegion(project) + ".amazonaws.com";
        }

        @NotNull
        public final KubeScanner getKubeScanner(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = DeployExtensionUtil.Companion.getExtension(project).getKubeScanner().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"DeployExtensionUtil.getE\u2026roject).kubeScanner.get()");
            return (KubeScanner)object;
        }

        @NotNull
        public final String getRegion(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            String string = this.getKubeScanner(project).getAwsRegion();
            if (string == null) {
                throw new RuntimeException("AWS Region has to be explicitly defined");
            }
            return string;
        }

        public final void buildKubeBench(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, project, "docker build -t k8s/kube-bench:" + this.getKubeScanner(project).getKubeBenchTagVersion() + " \"" + this.getKubeBenchDir(project) + "\"", null, this.getKubeScanner(project).getLogOutput(), false, 0L, 52, null);
        }

        @NotNull
        public final List<String> getCommand(@NotNull Project project, @NotNull List<String> existingCommand) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(existingCommand, (String)"existingCommand");
            if (this.getKubeScanner(project).getCommand().size() > 0) {
                existingCommand.addAll((Collection<String>)this.getKubeScanner(project).getCommand());
            }
            return existingCommand;
        }

        @NotNull
        public final KubeCtlHelper getKubectlHelper(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return new KubeCtlHelper(project, null, false, 4, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

