/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.tasks.cluster.helm;

import ai.digital.integration.server.common.cluster.helm.HelmHelper;
import ai.digital.integration.server.common.constant.ProductName;
import ai.digital.integration.server.common.util.GitUtil;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0016\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u0007\u001a\u00020\u0004H\u0007\u00a8\u0006\t"}, d2={"Lai/digital/integration/server/deploy/tasks/cluster/helm/ProvideDeployKubernetesHelmChartTask;", "Lorg/gradle/api/DefaultTask;", "()V", "cloneRepository", "", "branch", "", "launch", "Companion", "integration-server-gradle-plugin"})
public class ProvideDeployKubernetesHelmChartTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "provideDeployKubernetesHelmChart";

    @TaskAction
    public final void launch() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        HelmHelper helmHelper = HelmHelper.Companion.getHelmHelper(project, ProductName.DEPLOY);
        Object object = helmHelper.getProvider().getHelmBranch().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"helmHelper.getProvider().helmBranch.get()");
        String branch = (String)object;
        this.getProject().getLogger().lifecycle("Checking out xl-deploy-kubernetes-helm-chart branch " + branch);
        this.cloneRepository(branch);
    }

    private final void cloneRepository(String branch) {
        Path path = this.getProject().getBuildDir().toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"project.buildDir.toPath()");
        GitUtil.Companion.checkout("xl-deploy-kubernetes-helm-chart", path, branch);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/digital/integration/server/deploy/tasks/cluster/helm/ProvideDeployKubernetesHelmChartTask$Companion;", "", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

