/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.tasks.cli;

import ai.digital.integration.server.common.cluster.operator.OperatorHelper;
import ai.digital.integration.server.common.domain.profiles.OperatorHelmProfile;
import ai.digital.integration.server.common.domain.profiles.OperatorProfile;
import ai.digital.integration.server.common.util.XlCliUtil;
import ai.digital.integration.server.deploy.internals.DeployExtensionUtil;
import ai.digital.integration.server.release.internals.ReleaseExtensionUtil;
import de.undercouch.gradle.tasks.download.Download;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.tasks.Copy;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lai/digital/integration/server/deploy/tasks/cli/DownloadXlCliDistTask;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "Companion", "integration-server-gradle-plugin"})
public class DownloadXlCliDistTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "downloadXlCliDist";

    /*
     * Enabled aggressive block sorting
     */
    public DownloadXlCliDistTask() {
        Task task2;
        this.setGroup("Integration Server");
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (!DeployExtensionUtil.Companion.getExtension(project).getClusterProfiles().operator().getActiveProviderName().isPresent()) {
            Project project2 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            if (!ReleaseExtensionUtil.Companion.getExtension(project2).getClusterProfiles().operator().getActiveProviderName().isPresent()) {
                this.getProject().getLogger().warn("Active provider name is not set - DownloadXlCliDistTask");
                return;
            }
        }
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
        OperatorHelper operatorHelper = OperatorHelper.Companion.getOperatorHelper(project3);
        OperatorHelmProfile operatorHelmProfile = operatorHelper.getProfile();
        Intrinsics.checkNotNull((Object)operatorHelmProfile, (String)"null cannot be cast to non-null type ai.digital.integration.server.common.domain.profiles.OperatorProfile");
        OperatorProfile profile = (OperatorProfile)operatorHelmProfile;
        String taskName = "xlCliExec";
        if (profile.getXlCliPath().isPresent()) {
            Task task3;
            Object object = profile.getXlCliPath().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            final String path = (String)object;
            if (StringsKt.startsWith$default((String)path, (String)"http", (boolean)false, (int)2, null)) {
                Object[] objectArray = new Object[]{this.getProject().getTasks().register(taskName, Download.class, new Action(){

                    public final void execute(Download $this$register) {
                        Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$this$register");
                        $this$register.src((Object)path);
                        Project project = $this$register.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                        $this$register.dest((Object)XlCliUtil.Companion.localDir(project));
                    }
                })};
                task3 = this.dependsOn(objectArray);
                return;
            }
            Object[] objectArray = new Object[]{this.getProject().getTasks().register(taskName, Copy.class, new Action(){

                public final void execute(Copy $this$register) {
                    Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$this$register");
                    Object[] objectArray = new Object[]{path};
                    $this$register.from(objectArray);
                    Project project = $this$register.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    $this$register.into((Object)XlCliUtil.Companion.localDir(project));
                }
            })};
            task3 = this.dependsOn(objectArray);
            return;
        }
        if (!profile.getXlCliVersion().isPresent()) return;
        Object object = profile.getXlCliVersion().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        final String version = (String)object;
        this.getProject().getLogger().lifecycle("Downloading XL cli " + version + ".");
        if (((Boolean)profile.getCliNightly().get()).booleanValue()) {
            this.getProject().getDependencies().add("xlCliDist", (Object)("com.xebialabs.xlclient:xl-client:" + version + ":" + XlCliUtil.Companion.getOsFolder() + "@bin"));
            File file = this.getProject().getConfigurations().getByName("xlCliDist").getSingleFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getSingleFile(...)");
            final File fromFile = file;
            Object[] objectArray = new Object[]{this.getProject().getTasks().register(taskName, Copy.class, new Action(){

                public final void execute(Copy $this$register) {
                    Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$this$register");
                    Object[] objectArray = new Object[]{fromFile};
                    $this$register.from(objectArray);
                    Project project = $this$register.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    $this$register.into((Object)XlCliUtil.Companion.localDir(project));
                    $this$register.rename(fromFile.getName(), "xl");
                }
            })};
            task2 = this.dependsOn(objectArray);
            return;
        }
        Object[] objectArray = new Object[]{this.getProject().getTasks().register(taskName, Download.class, new Action(){

            public final void execute(Download $this$register) {
                Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$this$register");
                $this$register.src((Object)XlCliUtil.Companion.distUrl(version));
                Project project = $this$register.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                $this$register.dest((Object)XlCliUtil.Companion.localDir(project));
            }
        })};
        task2 = this.dependsOn(objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lai/digital/integration/server/deploy/tasks/cli/DownloadXlCliDistTask$Companion;", "", "<init>", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

