/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.rest.doclet;

import com.sun.javadoc.ParameterizedType;
import com.sun.javadoc.SeeTag;
import com.sun.javadoc.Tag;
import com.sun.javadoc.Type;
import com.xebialabs.commons.html.HtmlWriter;
import com.xebialabs.rest.doclet.FileCatalog;
import com.xebialabs.rest.doclet.RestDoclet;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class JavadocWriter
extends HtmlWriter {
    public JavadocWriter(PrintWriter writer) {
        super(writer);
    }

    protected String asText(Tag[] tags) {
        StringBuilder builder = new StringBuilder();
        for (Tag tag : tags) {
            if (tag instanceof SeeTag) {
                this.appendLink(builder, (SeeTag)tag);
                continue;
            }
            builder.append(tag.text());
        }
        return builder.toString();
    }

    private void appendLink(StringBuilder builder, SeeTag tag) {
        String file = RestDoclet.fileNameFor((Type)tag.referencedClass());
        if (file != null && FileCatalog.SINGLETON.getItems().contains(file)) {
            builder.append(this.link(file, new Object[]{tag.text()}));
        } else {
            builder.append(this.code(new Object[]{tag.text()}));
        }
    }

    protected String asText(Type type) {
        return JavadocWriter.asText(type, " of ", ", ", "");
    }

    protected String asReference(Type type) {
        return JavadocWriter.asText(type, "-", "-", ".html");
    }

    private static String asText(Type type, String separator1, String separator2, String end) {
        StringBuilder builder = new StringBuilder();
        builder.append(type.simpleTypeName());
        ParameterizedType paramType = type.asParameterizedType();
        if (paramType != null) {
            builder.append(separator1);
            for (int i = 0; i < paramType.typeArguments().length; ++i) {
                Type param = paramType.typeArguments()[i];
                builder.append(param.simpleTypeName());
                if (i >= paramType.typeArguments().length - 1) continue;
                builder.append(separator2);
            }
        }
        builder.append(end);
        return builder.toString();
    }

    public List<Type> getParameterizedTypes(Type type) {
        ArrayList<Type> types = new ArrayList<Type>();
        ParameterizedType paramType = type.asParameterizedType();
        if (paramType != null) {
            for (Type param : paramType.typeArguments()) {
                types.add(param);
            }
        }
        return types;
    }
}

