package com.xebialabs.xlplatform.upgrade.sql

import com.xebialabs.deployit.server.api.upgrade.Version
import com.xebialabs.xlplatform.repository.sql.Database
import com.xebialabs.xlplatform.upgrade.RepositoryVersionService
import com.xebialabs.xlplatform.upgrade.sql.db.Tables
import org.springframework.beans.factory.annotation.Autowired
import slick.jdbc.JdbcProfile

import java.util


class SqlRepositoryVersionService @Autowired()(database: Database) extends RepositoryVersionService {

  import database._

  val profile: JdbcProfile = config.databaseType.profile

  import profile.api._

  override def storeVersionOfComponent(version: Version): Unit = runAwait {
    Tables.versions.insertOrUpdate(Tables.Version(version.getComponent, version.getVersion))
  }

  override def readVersionOfComponent(component: String): Version = runAwait {
    Tables.versions.filter(_.component === component).result
  }.map(versionData => Version.valueOf(versionData.component, versionData.version)).headOption.orNull

  override def getAllComponentVersions(): util.Map[String, String] = {
    val componentVersionMap: util.Map[String, String] = new util.HashMap[String, String]()
    val versions = runAwait {
        Tables.versions.result
      }.map(versionData => componentVersionMap.put(versionData.component, versionData.version))
    componentVersionMap
  }
}
