package com.xebialabs.xlplatform.upgrade.sql

import java.util

import com.xebialabs.deployit.server.api.upgrade.{RepoType, Upgrade, UpgradeException}
import com.xebialabs.deployit.upgrade.UpgradeStrategy
import grizzled.slf4j.Logging

import scala.collection.JavaConverters._

class SqlUpgradeStrategy extends UpgradeStrategy with Logging {
  override def findApplicableUpgradeTypes(): util.Set[Class[_ <: Upgrade]] = UpgradeStrategy.findApplicableUpgradeTypes(RepoType.SQL)

  override def doUpgrades(upgrades: util.List[Upgrade]): Unit = {
    upgrades.asScala.foreach { upgrade =>
      logger.debug(s"Running upgrade [$upgrade]")
      if (!upgrade.doUpgrade()) {
        throw new UpgradeException(s"Could not perform upgrade [$upgrade] to upgrade to [${upgrade.upgradeVersion()}]")
      }
    }
  }
}
