package com.xebialabs.satellite.serialization

import com.esotericsoftware.kryo.Kryo
import com.esotericsoftware.kryo.io.{Input, Output}
import com.esotericsoftware.kryo.serializers.FieldSerializer
import com.esotericsoftware.kryo.serializers.FieldSerializer.CachedField
import com.xebialabs.deployit.engine.spi.execution.{NonRemotableExecutionStateListener, ExecutionStateListener}
import com.xebialabs.deployit.engine.tasker.TaskSpecification

import scala.util.Try

class TaskSpecificationSerializer(kryo: Kryo) extends FieldSerializer[TaskSpecification](kryo, classOf[TaskSpecification]) {

  override def initializeCachedFields(): Unit = {
    getFields.find(_.getField.getName == "listeners").foreach(removedFields.add)
  }

  override def removeField(fieldName: ArtifactId): Unit = Try(super.removeField(fieldName))

  override def removeField(removeField: CachedField[_]): Unit = Try(super.removeField(removeField))

  override def write(kryo: Kryo, output: Output, task: TaskSpecification): Unit = {
    super.write(kryo, output, task)

    import collection.convert.wrapAsScala._

    kryo.writeClassAndObject(output, task.getListeners.collect {
      case listener: ExecutionStateListener if !listener.isInstanceOf[NonRemotableExecutionStateListener] => listener
    })
  }

  override def read(kryo: Kryo, input: Input, `type`: Class[TaskSpecification]): TaskSpecification = {
    val task = super.read(kryo, input, `type`)
    val listeners = kryo.readClassAndObject(input).asInstanceOf[Seq[ExecutionStateListener]]

    val field = classOf[TaskSpecification].getDeclaredField("listeners")
    field.setAccessible(true)
    field.set(task, collection.convert.wrapAsJava.seqAsJavaList(listeners))
    task
  }
}
