package com.xebialabs.satellite.future

import java.util.concurrent.Semaphore

import scala.concurrent.{ExecutionContext, Future}
import scala.util.{Failure, Success, Try}

trait AwaitForever {

  def blockOn[T](future: Future[T])(implicit ec:ExecutionContext): Try[T] = {
    val readySemaphore = new Semaphore(0)
    var futureResult: Try[T] = Failure(new RuntimeException("Promise not completed yet"))

    future.onComplete {
      result =>
        futureResult = result
        readySemaphore.release()
    }

    readySemaphore.acquire()

    futureResult
  }

  def blockOrThrow[T](future: Future[T])(implicit ec:ExecutionContext): T = {
    blockOn(future) match {
      case Success(t) => t
      case Failure(e) => throw e
    }
  }
}