package com.xebialabs.deployit.plugin.satellite

import akka.actor._
import com.xebialabs.deployit.plugin.satellite.UploadTaskSupervisor.Protocol.UploadFilesTask

class StreamingSupervisor extends Actor {
  def receive: Receive = {
    case task: UploadFilesTask =>
      val taskSupervisor = UploadTaskSupervisor.props(sender(), task)
      val satAddress = task.config.satelliteAddress
      context.actorOf(taskSupervisor,
        s"upload-supervisor-${task.config.taskId}-${satAddress.name}-${satAddress.hostname}:${satAddress.protocolPort}")
  }
}

object StreamingSupervisor {
  def props(): Props = Props[StreamingSupervisor]
}