package com.xebialabs.deployit.plugin.satellite

import java.io.{File, FileInputStream, InputStream}

import com.xebialabs.deployit.io.LazyLocalFile

class PluginLocalFile(file: File) extends LazyLocalFile(null, file) {

  override def getRawStream: InputStream = {
    new FileInputStream(file)
  }

  override def getName: String = file.getName
}

object PluginLocalFile {
  def apply(file:File) = new PluginLocalFile(file)
}


