package com.xebialabs.deployit.plugin.satellite

import java.io.ObjectInputStream

import akka.actor.ActorSystem
import com.xebialabs.deployit.engine.tasker.satellite.ActorLocator
import com.xebialabs.deployit.plugin.api.flow.{ExecutionContext, Step, StepExitCode}
import com.xebialabs.xlplatform.satellite.Satellite

import scala.beans.BeanProperty

case class PingSatelliteStep(actorLocator: ActorLocator, @BeanProperty description: String, satelliteAddress: SatelliteAddress, clock: Clock = Clock())
                            (implicit @transient var satelliteCommunicatorSystem: ActorSystem) extends Step {

  def getOrder: Int = Step.DEFAULT_ORDER

  def execute(ctx: ExecutionContext): StepExitCode = if (Pinger.isUp(satelliteAddress, actorLocator, Pinger.defaultPingTimeout(satelliteCommunicatorSystem), Pinger.FIVE_PINGS, clock)(ctx, satelliteCommunicatorSystem)) StepExitCode.SUCCESS else StepExitCode.FAIL

  private def readObject(in: ObjectInputStream): Unit = {
    in.defaultReadObject()
    satelliteCommunicatorSystem = SatelliteCommunicatorSystem.actorSystem
  }
}

object PingSatelliteStep {

  def apply(satellite: Satellite)(implicit satelliteCommunicatorSystem: ActorSystem): PingSatelliteStep = {
    new PingSatelliteStep(ActorLocator(satellite), s"Ping ${satellite.getName}", SatelliteAddress(satellite))
  }

  private[satellite] def apply(satellite: Satellite, actorLocator: ActorLocator, clock: Clock)(implicit satelliteCommunicatorSystem: ActorSystem): PingSatelliteStep = {
    new PingSatelliteStep(actorLocator, s"Ping ${satellite.getName}", SatelliteAddress(satellite), clock)
  }
}
