package com.xebialabs.deployit.plugin.satellite

import java.io.File
import java.net.URI

import akka.actor.ActorSystem
import akka.pattern._
import akka.util.Timeout
import com.xebialabs.deployit.engine.tasker.satellite.ActorLocator
import com.xebialabs.deployit.plugin.satellite.extension.ExtensionsLocator
import com.xebialabs.satellite.protocol.{GetInstalledExtensions, InstalledExtensions, Paths}
import com.xebialabs.xlplatform.io.FolderChecksum
import com.xebialabs.xlplatform.settings.CommonSettings

import scala.concurrent.Await

object ExtensionsDelta {

  def calculateExtensionsDelta(extensionsLocator: ExtensionsLocator, actorLocator: ActorLocator, satelliteCommunicatorSystem: ActorSystem): InstalledExtensionsDelta = {
    implicit val timeout: Timeout = CommonSettings(satelliteCommunicatorSystem).satellite.pingTimeout

    val satellitePluginManagement = actorLocator.locate(Paths.pluginManagement)(satelliteCommunicatorSystem)

    val satelliteInstalledExtensions = Await.result(
      (satellitePluginManagement ? GetInstalledExtensions).mapTo[InstalledExtensions], atMost = timeout.duration)

    InstalledExtensionsDelta(
      compareChecksum(satelliteInstalledExtensions.pluginsChecksum, extensionsLocator.plugins),
      compareChecksum(satelliteInstalledExtensions.pluginHotfixesChecksum, extensionsLocator.pluginHotfixes),
      compareChecksum(satelliteInstalledExtensions.satelliteHotfixesChecksum, extensionsLocator.satelliteHotfixes),
      compareChecksum(satelliteInstalledExtensions.extChecksum, extensionsLocator.ext))
  }

  private def compareChecksum(checksum: String, files: List[File]): Set[URI] = {
    if (checksum == FolderChecksum.calculateChecksum(files)) {
      Set.empty
    } else {
      files.map(_.toURI).toSet
    }
  }
}
