package com.xebialabs.deployit.plugin.satellite

import akka.actor.{Actor, ActorSelection, Props}
import com.xebialabs.deployit.engine.tasker.StateChangeEventListenerActor.TaskStateEvent
import com.xebialabs.deployit.engine.tasker.TaskId
import com.xebialabs.deployit.engine.tasker.messages.RemoteTaskStateEvent
import grizzled.slf4j.Logging

object TaskEventForwarder {
  def props(taskId: TaskId, remoteTaskActor: ActorSelection) = Props(classOf[TaskEventForwarder], taskId, remoteTaskActor)
}

class TaskEventForwarder(val taskId: TaskId, val remoteTaskActor: ActorSelection) extends Actor with Logging {
  override def receive: Receive = {
    case msg@TaskStateEvent(`taskId`, _, prevState, currState) =>
      debug(s"sending $msg to remote")
      remoteTaskActor ! RemoteTaskStateEvent(taskId, prevState, currState)
      if (currState.isFinal)
        context.stop(self)
  }
}
