package com.xebialabs.xlplatform.test

import org.scalatest.{BeforeAndAfterEachTestData, Suite, TestData}
import grizzled.slf4j.Logging

trait TestNameLogging extends Logging with BeforeAndAfterEachTestData { this: Suite =>

  override protected def beforeEach(td: TestData): Unit = {
    logger.info(s"==== Start: ${td.name} ====")
    super.beforeEach(td)
  }

  override protected def afterEach(td: TestData): Unit = {
    super.afterEach(td)
    logger.info(s"==== Done: ${td.name} ====")
  }

}
