package com.xebialabs.xlplatform.test

import akka.actor.ActorSystem
import akka.testkit.{ImplicitSender, TestKit}
import org.junit.runner.RunWith
import org.scalatest.junit.JUnitRunner

@RunWith(classOf[JUnitRunner])
abstract class ActorTestBase(_system: ActorSystem) extends TestKit(_system) with ImplicitSender with UnitTestBase {
  def this() = this(ActorSystem())

  override def afterAll() {
    TestKit.shutdownActorSystem(system)
  }
}
