package com.xebialabs.xlplatform.test

import java.util.concurrent.TimeUnit

import akka.actor.ActorRefFactory
import org.scalatest.BeforeAndAfterAll
import akka.http.scaladsl.testkit.{RouteTestTimeout, ScalatestRouteTest}

import scala.concurrent.duration._

trait RouteTestBase extends UnitTestBase with ScalatestRouteTest with BeforeAndAfterAll {

  def actorRefFactory: ActorRefFactory = system

  lazy val akkaTimeFactor = system.settings.config.getDouble("akka.test.timefactor")
  lazy val akkaTimeout = system.settings.config.getDuration("akka.test.default-timeout", TimeUnit.MILLISECONDS)
  lazy val akkaTimeoutWithFactor = (akkaTimeFactor * akkaTimeout).toLong
  implicit lazy val routeTestTimeout = RouteTestTimeout(FiniteDuration(akkaTimeoutWithFactor, MILLISECONDS))

}
