package com.xebialabs.xlplatform.test

import org.apache.pekko.actor.ActorRefFactory
import org.apache.pekko.http.scaladsl.testkit.{RouteTestTimeout, ScalatestRouteTest}
import org.scalatest.BeforeAndAfterAll

import java.util.concurrent.TimeUnit
import scala.concurrent.duration._

trait RouteTestBase extends UnitTestBase with ScalatestRouteTest with BeforeAndAfterAll {

  def actorRefFactory: ActorRefFactory = system

  lazy val pekkoTimeFactor = system.settings.config.getDouble("pekko.test.timefactor")
  lazy val pekkoTimeout = system.settings.config.getDuration("pekko.test.default-timeout", TimeUnit.MILLISECONDS)
  lazy val pekkoTimeoutWithFactor = (pekkoTimeFactor * pekkoTimeout).toLong
  implicit lazy val routeTestTimeout = RouteTestTimeout(FiniteDuration(pekkoTimeoutWithFactor, MILLISECONDS))

}
