package com.xebialabs.deployit.tasksystem

import akka.actor.ActorSystem
import com.typesafe.config.ConfigFactory._
import com.typesafe.config.{Config, ConfigFactory}

object TaskActorSystem {

  lazy val actorSystem: ActorSystem = newActorSystem(overrideConfig.withFallback(parseResources("xl-deploy.conf")))

  var overrideConfig: Config = ConfigFactory.empty()

  def setOverrideConfig(newConfig: Config): Unit = {
    overrideConfig = newConfig
  }

  def newActorSystem(systemConfig: Config, systemName: Option[String] = None): ActorSystem = {
    val actorConfig = if (systemConfig.hasPath("xl.task.system"))
      systemConfig.getConfig("xl.task.system").withFallback(systemConfig)
    else
      systemConfig
    ActorSystem.create(systemName.getOrElse("task-sys"), ConfigLoading.loadConfig(actorConfig))
  }
}
