package com.xebialabs.xlplatform.test.tasksystem

import java.util

import akka.actor.ActorPath
import com.xebialabs.deployit.engine.tasker.repository.{ActiveTask, ActiveTaskRepository}
import com.xebialabs.deployit.engine.tasker.{TaskId, TaskSpecification}
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken

import scala.collection.mutable

class InMemoryActiveTaskRepository extends ActiveTaskRepository {

  private val _tasks = mutable.Map[TaskId, (TaskSpecification, String)]()

  override def store(taskId: TaskId, spec: TaskSpecification, path: ActorPath): Unit = {
    _tasks.put(taskId, (spec, path.address.toString))
  }

  override def store(taskId: TaskId, description: String, owner: String, workerId: Integer, metadata: util.Map[String, String]): Unit = {
    val spec = new TaskSpecification(description, new UsernamePasswordAuthenticationToken(owner, "s3cret"), null, null)
    _tasks.put(taskId, (spec, null))
  }

  override def changeOwner(taskId: TaskId, newOwner: String): Unit = ???

  override def workerAddress(taskId: TaskId): Option[String] = {
    _tasks.get(taskId).map(_._2)
  }

  override def task(taskId: TaskId): Option[ActiveTask] = {
    _tasks.get(taskId).map(_._1).map(activeTask(taskId))
  }

  override def tasks(): List[ActiveTask] = {
    _tasks.map { case (id, (spec, _)) => activeTask(id)(spec) }.toList
  }

  private def activeTask(id: TaskId)(spec: TaskSpecification) = {
    new ActiveTask(id, spec.getDescription, spec.getOwner.getName, spec.getMetadata, null)
  }

  override def delete(taskid: TaskId): Unit = {
    _tasks.remove(taskid)
  }

  override def ciPathsByDeployments(taskIds: List[TaskId]): Map[TaskId, List[String]] = {
    throw new NotImplementedError()
  }

  override def ciPathsByControlTasks(taskIds: List[TaskId]): Map[TaskId, List[String]] = {
    throw new NotImplementedError()
  }
}
