package com.xebialabs.xlplatform.test.tasksystem

import com.xebialabs.deployit.engine.api.distribution.TaskExecutionWorkerRepository
import com.xebialabs.deployit.engine.api.dto.Worker

import java.util.concurrent.CountDownLatch

class SingleWorkerRepository extends TaskExecutionWorkerRepository {

  val latch = new CountDownLatch(1)

  var worker: Worker = _

  def awaitRegistration(): Unit = {
    latch.await()
  }

  override def storeWorker(worker: Worker): Unit = {
    this.worker = worker
    latch.countDown()
  }

  override def getWorker(id: Integer): Option[Worker] = Option(worker)

  override def getWorkerByAddress(address: String): Option[Worker] = Option(worker)

  override def removeWorker(id: Integer): Unit = {}

  override def removeWorker(address: String): Unit = {}

  override def listWorkers: List[(Worker, Integer, Integer)] = Option(worker).map(w => List((w, Integer.valueOf(0), Integer.valueOf(0)))).getOrElse(List())

  override def removeTasks(id: Integer): Unit = {}
}
