package com.xebialabs.deployit.io;

import org.springframework.core.io.Resource;

import java.io.IOException;
import java.io.InputStream;

public class ConfigurationResource {

    private final String path;
    private final String httpUrl;
    private final Resource resource;

    public ConfigurationResource(String path, String httpUrl, Resource resource) {
        this.path = path;
        this.httpUrl = httpUrl;
        this.resource = resource;
    }

    public String getPath() {
        return path;
    }

    public String getUrl() {
        return httpUrl;
    }

    public Resource getResource() {
        return resource;
    }

    public InputStream getInputStream() throws IOException {
        return resource.getInputStream();
    }

    public boolean exists() {
        return resource.exists();
    }
}
