/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.spi.exception;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import static java.lang.String.format;

@SuppressWarnings("serial")
@HttpResponseCodeResult
@SuppressStackTrace
public class DeployitException extends RuntimeException {

    private final List<String> errors = new ArrayList<>();
    private Object entity;

    public DeployitException() {
    }

    public DeployitException(String message) {
        errors.add(message);
    }

    public DeployitException(final String messageTemplate, final Object... params) {
        errors.add(format(messageTemplate, params));
    }

    public DeployitException(final Throwable cause, final String messageTemplate, final Object... params) {
        super(cause);
        errors.add(format(messageTemplate, params));
    }

    public DeployitException(final Throwable cause) {
        super(cause);
    }

    public DeployitException(Object entity) {
        this.entity = entity;
    }
    
    public void add(String messageTemplate, final Object... params) {
        errors.add(format(messageTemplate, params));
    }

    public void addAll(Collection<String> messages) {
        errors.addAll(messages);
    }

    public boolean hasErrors() {
        return !errors.isEmpty();
    }

    public List<String> getErrors() {
        return errors;
    }

    @Override
    public String getMessage() {
        if (errors.isEmpty()) {
            return "";
        }

        StringBuilder sb = new StringBuilder(errors.get(0));
        for (int i = 1; i < errors.size(); i++) {
            sb.append('\n').append(errors.get(i));
        }
            return sb.toString();
    }

    public boolean hasEntity() {
        return entity != null;
    }
    
    public Object getEntity() {
        return entity;
    }
}
