package com.xebialabs.xlplatform.coc.rest

import com.xebialabs.xlplatform.coc.dto.SCMTraceabilityData
import com.xebialabs.xlplatform.coc.service.SCMTraceabilityService
import com.xebialabs.xlplatform.documentation.PublicApi
import jakarta.ws.rs._
import jakarta.ws.rs.core.MediaType
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Controller

@Controller
@Autowired
@Path("/coc/scm-traceability")
@Consumes(Array(MediaType.APPLICATION_JSON))
@Produces(Array(MediaType.APPLICATION_JSON))
@PublicApi
/**
  * Manages SCM (source control management) traceability data.
  */
class SCMTraceabilityResource(service: SCMTraceabilityService) {

  /**
    * Retrieves SCM traceability data by it's id
    * @param id - SCM traceability id
    * @return SCM traceability data
    */
  @GET
  def getById(@QueryParam("id") id: String): SCMTraceabilityData = service.getById(id).getOrElse(throw new IllegalArgumentException(s"Cannot find traceability data with id: $id"))
}
