package com.xebialabs.xlplatform.coc.service

import com.xebialabs.xlplatform.coc.dto.SCMTraceabilityData

case class PersistenceParams(traceabilityId: Option[String],
                             scmTraceabilityData: Option[SCMTraceabilityData])

trait SCMTraceabilityService {
  def getById(id: String): Option[SCMTraceabilityData]
  protected def insert(scmTraceabilityData: SCMTraceabilityData): Option[String]
  protected def update(traceabilityId: String, scmData: SCMTraceabilityData): Option[String]
  protected def delete(id: String): Option[String]

  def persistOrDelete(persistenceParams: PersistenceParams): Option[String] = {
    persistenceParams match {
      case PersistenceParams(Some(traceabilityId), Some(data)) => update(traceabilityId, data)
      case PersistenceParams(Some(traceabilityId), None) => delete(traceabilityId)
      case PersistenceParams(None, Some(data)) => insert(data)
      case _ => None
    }
  }
}
