package com.xebialabs.xlplatform.cluster

import akka.actor.{ActorSystem, ExtendedActorSystem, Extension, ExtensionId, ExtensionIdProvider}
import akka.cluster.Cluster
import com.xebialabs.xlplatform.cluster.ClusterMode.{Full, HotStandby}
import com.xebialabs.xlplatform.cluster.full.FullClusterNodeStateManager
import com.xebialabs.xlplatform.cluster.hotstandby.HotStandbyClusterNodeStateManager
import com.xebialabs.xlplatform.cluster.membership.ClusterDiscoveryActor
import com.xebialabs.xlplatform.cluster.membership.storage.ClusterMembershipManagement

object XlCluster extends ExtensionId[XlClusterProvider] with ExtensionIdProvider {
  var config: ClusterConfig = _

  def init(config: ClusterConfig): Unit = {
    this.config = config
  }

  override def lookup(): ExtensionId[_ <: Extension] = this

  override def createExtension(system: ExtendedActorSystem): XlClusterProvider = new XlClusterProvider(system, config)

  override def get(system: ActorSystem): XlClusterProvider = super.get(system)
}


class XlClusterProvider(extendedSystem: ExtendedActorSystem, config: ClusterConfig) extends Extension {
  private implicit val system = extendedSystem

  private implicit val executionContext = extendedSystem.dispatcher

  private val cluster = Cluster(system)

  val membershipManagement = ClusterMembershipManagement.selectDialect(config.membership.datasource, config.membership.ttl)

  def start(initialize: () => Unit): Unit = {
    val clusterStateManagerActor = config.mode match {
      case Full =>
        system.actorOf(FullClusterNodeStateManager.stateManager(initialize))
      case HotStandby =>
        system.actorOf(HotStandbyClusterNodeStateManager.stateManager(initialize))
      case _ => throw new IllegalArgumentException("This extension is only valid with cluster usage.")
    }
    val discoveryActor = system.actorOf(ClusterDiscoveryActor.props(cluster, membershipManagement, config.membership.heartbeatInterval))
    discoveryActor ! ClusterDiscoveryActor.Start(clusterStateManagerActor)
  }

}
