package com.xebialabs.xlplatform.cluster.membership.storage

import java.sql.SQLException

import com.xebialabs.xlplatform.cluster.DataSourceConfig
import com.xebialabs.xlplatform.cluster.membership.storage.ClusterMembershipManagement.{Failure, Result, Success}

import scala.concurrent.duration.FiniteDuration
import scala.concurrent.{ExecutionContext, Future}

class ClusterMembershipH2Dialect(clusterMembershipDataSource: DataSourceConfig, ttl: FiniteDuration, failFast: Boolean = true)
  extends ClusterMembershipSQLManagement(clusterMembershipDataSource, ttl, failFast) {
  override def driverName: String = "org.h2.Driver"

  override def createManagementInfra()(implicit executionContext: ExecutionContext): Future[Result] = {
    Future {
      withConnection { con =>
        try {
          con.prepareStatement(
            """
              |CREATE TABLE IF NOT EXISTS cluster_members(
              |  protocol VARCHAR(255) NOT NULL,
              |  system VARCHAR(255) NOT NULL,
              |  host VARCHAR(255) NOT NULL,
              |  port INT NOT NULL,
              |  ttl TIMESTAMP(8) NOT NULL,
              |  PRIMARY KEY (protocol, system, host, port)
              |)""".stripMargin).execute()
          con.commit()
          Success
        } catch {
          case sqlEx: SQLException => Failure(s"${sqlEx.getErrorCode} is the SQL error code: ${sqlEx.getMessage}")
          case ex: Exception => Failure(ex.getMessage)
        }
      }
    }
  }

  override def registerSelfSql: String = {
    """
      |INSERT INTO cluster_members(protocol, system, host, port, ttl)
      |VALUES (?, ?, ?, ?, DATEADD('SECOND', ?, CURRENT_TIMESTAMP))""".stripMargin
  }

  override def heartbeatSql: String = {
    "UPDATE cluster_members SET ttl = DATEADD('SECOND', ?, CURRENT_TIMESTAMP) WHERE host = ? and port = ?"
  }

}
